#!/usr/bin/env bash

FILE="/etc/ssh/sshd_config"

TEXT_CIPHER_COMMENT="# Ciphers and keying"
TEXT_INI_K="KexAlgorithms curve25519"
TEXT_INI_C="Ciphers aes128"
TEXT_INI_M="MACs hmac"

TEXT_KEXALGORITHMS="KexAlgorithms curve25519-sha256,curve25519-sha256@libssh.org,diffie-hellman-group-exchange-sha256,diffie-hellman-group14-sha256,diffie-hellman-group16-sha512,diffie-hellman-group18-sha512,ecdh-sha2-nistp256,ecdh-sha2-nistp384,ecdh-sha2-nistp521"
TEXT_CIPHER="Ciphers aes128-ctr,aes128-gcm@openssh.com,aes192-ctr,aes256-ctr,aes256-gcm@openssh.com,chacha20-poly1305@openssh.com"
TEXT_MAC="MACs hmac-sha2-256,hmac-sha2-256-etm@openssh.com,hmac-sha2-512,hmac-sha2-512-etm@openssh.com,umac-128-etm@openssh.com,umac-128@openssh.com"

if test -f "$FILE"; then

    POS_CC=$(grep -n "$TEXT_CIPHER_COMMENT" "$FILE" | cut -d : -f 1)
    POS_K=$(grep -n "$TEXT_INI_K" "$FILE" | cut -d : -f 1)
    POS_C=$(grep -n "$TEXT_INI_C" "$FILE" | cut -d : -f 1)
    POS_M=$(grep -n "$TEXT_INI_M" "$FILE" | cut -d : -f 1)
    
    if [ ! -z $POS_CC ];then

	if [ -z $POS_K ];then
		POS_K=$(($POS_CC+2))
		sudo sed -i "$POS_K a $TEXT_KEXALGORITHMS\n" "$FILE"	
	fi

	if [ -z $POS_C ];then
		POS_C=$(($POS_CC+4))
		sudo sed -i "$POS_C a $TEXT_CIPHER\n" "$FILE"
	fi

	if [ -z $POS_M ];then
		POS_M=$(($POS_CC+6))
		sudo sed -i "$POS_M a $TEXT_MAC\n" "$FILE"
	fi

    fi

    if [ -z $POS_CC ];then

	if [ -z $POS_K ];then
		sudo sed -i "$ a $TEXT_KEXALGORITHMS\n" "$FILE"	
	fi

	if [ -z $POS_C ];then
		sudo sed -i "$ a $TEXT_CIPHER\n" "$FILE"
	fi

	if [ -z $POS_M ];then
		sudo sed -i "$ a $TEXT_MAC\n" "$FILE"
	fi

    fi
	
fi


