#!/usr/bin/env bash

file="/var/www/html/acm/.env"
if [ -f "$file" ]
then
  while IFS='=' read -r key value
  do
    key=$(echo $key | tr '.' '_')
    eval ${key}=\${value}
  done < "$file"

  basename=$(echo ${OPENLDAP_BASE_DN})
else
  basename=""
fi

temp="${basename%\"}"
temp="${temp#\"}"
basename=$temp

if [[ "$basename" == "" ]]; then
    sudo ldapsearch -x -h localhost -s base namingContext
else
    sudo ldapsearch -x -h localhost -s base namingContext -D "cn=ldapadmin,$basename" -w 'acc3ss4LDAP@CM$!' -b "$basename"
fi