#!/usr/bin/env bash

echo "Starting replication process with mongo " > /home/akkadianuser/logs/replica_init_process_aco.log
date >> /home/akkadianuser/logs/replica_init_process_aco.log

echo "Acting as Replica cluster" >> /home/akkadianuser/logs/replica_init_process_aco.log
MASTER=$(sudo hostname)
NODES=$(head -n 1 /home/akkadianuser/load_balancer.config)
hostname=$(sudo hostname)


ran=$(( ( RANDOM % 100 )  + 1 ))
gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_aco.gpg > /home/akkadianuser/.sshpass_$ran

# shellcheck disable=SC2129
echo "master: $MASTER" >> /home/akkadianuser/logs/replica_init_process_aco.log
echo "nodes: $NODES" >> /home/akkadianuser/logs/replica_init_process_aco.log
echo "hostname: $hostname" >> /home/akkadianuser/logs/replica_init_process_aco.log

# Get MASTER db and replicate to all nodes, to start all at same point
# checksum to see if the file is correctly passed into slaves.
# no matter who is master, just ensure db is same in all slaves.
echo "Get MASTER db and replicate to all nodes, to start all at same point" >> /home/akkadianuser/logs/replica_init_process_aco.log

sudo rm -Rf /opt/akkadian/data/restore/AcoServer
sudo rm -Rf acoServer_base.tar.gz
sudo mongodump -u mongoDBuser -p X46kTVmongo --authenticationDatabase admin --db AcoServer -o /opt/akkadian/data/restore/
sudo tar -zcvf /opt/akkadian/data/restore/acoServer_base.tar.gz -C /opt/akkadian/data/restore/AcoServer/ .

echo "Stopping aco and tomcat on local" >> /home/akkadianuser/logs/replica_init_process_aco.log
sudo systemctl stop aco-server
sudo systemctl stop tomcat


IFS=$' '
for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) && "$j" != "$hostname" ]]
        then
            echo "Stopping aco and tomcat on $j"
            echo "Stopping aco and tomcat on $j" >> /home/akkadianuser/logs/replica_init_process_aco.log
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo systemctl stop aco-server"
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo systemctl stop tomcat"
        fi
done

nodes_len=0
initialization_string=""
IFS=$' '
for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]];
        then
            nodes_len=$(($nodes_len+1))
            echo "processing start configs for: $j"
            echo "processing start configs for: $j" >> /home/akkadianuser/logs/replica_init_process_aco.log

            #Ensuring slaves have always same data
            echo "Restoring the db in the other nodes" >> /home/akkadianuser/logs/replica_init_process_aco.log
            echo "phostname: $hostname"
            if [[ "$j" != "$hostname" ]]
            then
                sshpass -f /home/akkadianuser/.sshpass_$ran scp -o StrictHostKeyChecking=no /opt/akkadian/data/restore/acoServer_base.tar.gz root@$j:/opt/akkadian/data/restore/acoServer_base.tar.gz
                sleep 5
                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo rm -Rf /opt/akkadian/data/restore/AcoServer"
                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo mkdir /opt/akkadian/data/restore/AcoServer"
                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "tar -zxvf /opt/akkadian/data/restore/acoServer_base.tar.gz -C /opt/akkadian/data/restore/AcoServer"
                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sh /opt/akkadian/aco-server/scripts/mongoacorestore.sh"
                echo "Restoring db..." >> /home/akkadianuser/logs/replica_init_process_aco.log
                sleep 15
            fi

            #sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo systemctl stop mongodb"
            echo "Setting up the replicapass file on $j..." >> /home/akkadianuser/logs/replica_init_process_aco.log
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo echo replicapass > /opt/akkadian/data/mongokey "
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo chmod 600 /opt/akkadian/data/mongokey "
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo cp -Rf /home/akkadianuser/scripts/mongo_replica_scripts/start-mongo-replica.sh /opt/akkadian/aco-server/scripts/start-mongodb.sh"
            sleep 5
            echo "Stopping mongo" >> /home/akkadianuser/logs/replica_init_process_aco.log
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo systemctl stop mongodb"
            sleep 5

            if [[ -z $initialization_string ]];
            then
                # shellcheck disable=SC2116
                initialization_string=$(echo "$j")
            else
                initialization_string=$(echo "$initialization_string,$j")
            fi
        fi
done

sudo echo "the initialization string is: $initialization_string" >> /home/akkadianuser/logs/replica_init_process_aco.log
sudo echo "$initialization_string" > /opt/akkadian/data/replica
sudo chmod 666 /opt/akkadian/data/replica
nodes_comma_separated=$(cat /opt/akkadian/data/replica)
echo "Adding node list information into applicationContext-mongo_replicaSet.xml to configure aCO Web" >> /home/akkadianuser/logs/replica_init_process_aco.log
yes | sudo cp -Rf /home/akkadianuser/scripts/mongo_replica_scripts/applicationContext-mongo_replicaSet.xml /tmp/applicationContext-mongo_replicaSet.xml
sudo sed -i "s/list_of_nodes/$nodes_comma_separated/g" /tmp/applicationContext-mongo_replicaSet.xml
yes | sudo cp -Rf /tmp/applicationContext-mongo_replicaSet.xml /opt/tomcat/webapps/acow-webapp/WEB-INF/applicationContext-mongo.xml
sleep 5

echo "initiate master node: $MASTER running " >> /home/akkadianuser/logs/replica_init_process_aco.log
#sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$MASTER 'date' >> /home/akkadianuser/mongo_replica.log
sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$MASTER "sudo systemctl start mongodb"
sleep 5
echo "rs.initiate()" >> /home/akkadianuser/logs/replica_init_process_aco.log
sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$MASTER 'mongo admin -u mongoDBuser -p X46kTVmongo --eval "rs.initiate()"' >> /home/akkadianuser/logs/replica_init_process_aco.log
IFS=$' '
echo "nodes: $NODES"
for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]
        then
            echo "processing string for $j" >> /home/akkadianuser/logs/replica_init_process_aco.log

            if [[ "$j" != "$hostname" ]]; then
                echo "Adding node list information into applicationContext-mongo_replicaSet.xml to configure aCO Web on node $j" >> /home/akkadianuser/logs/replica_init_process_aco.log
                sshpass -f /home/akkadianuser/.sshpass_$ran scp -o StrictHostKeyChecking=no /opt/akkadian/data/replica root@$j:/opt/akkadian/data/replica
                sshpass -f /home/akkadianuser/.sshpass_$ran scp -o StrictHostKeyChecking=no /opt/akkadian/data/key/aco.properties root@$j:/opt/akkadian/data/key/aco.properties
                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo chmod 666 /opt/akkadian/data/replica"
                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "yes | sudo cp -Rf /home/akkadianuser/scripts/mongo_replica_scripts/applicationContext-mongo_replicaSet.xml /tmp/applicationContext-mongo_replicaSet.xml"
                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sed -i 's/list_of_nodes/$nodes_comma_separated/g' /tmp/applicationContext-mongo_replicaSet.xml"
                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "yes | sudo cp -Rf  /tmp/applicationContext-mongo_replicaSet.xml /opt/tomcat/webapps/acow-webapp/WEB-INF/applicationContext-mongo.xml"
            fi

            ######## Opening port to receive sync from the other nodes
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo firewall-cmd --add-port=6789/tcp --permanent"
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo firewall-cmd --reload"

            tmp=$j
            echo "$MASTER"
            echo "$j"
            if [[ "$MASTER" != "$j" ]]
            then
                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo systemctl start mongodb"
                sleep 5
                echo "adding node: $j to the replica set in mongo "
                echo "adding node: $j to the replica set in mongo " >> /home/akkadianuser/logs/replica_init_process_aco.log
                j="\"$j\""

                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$MASTER "mongo admin -u mongoDBuser -p X46kTVmongo --eval 'rs.add($j)'"  >> /home/akkadianuser/mongo_replica.log
            fi
            echo "restarting aco-server in $j"
            echo "restarting aco-server in $j" >> /home/akkadianuser/logs/replica_init_process_aco.log
            sleep 2
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$tmp "sudo echo '$MASTER' > /home/akkadianuser/master"
        fi
done

sleep 10
echo "Starting aco and tomcat on local" >> /home/akkadianuser/logs/replica_init_process_aco.log
sudo systemctl start aco-server
sleep 5
sudo systemctl start tomcat

IFS=$' '
for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) && "$j" != "$hostname" ]]
        then
            echo "Starting aco and tomcat on $j" >> /home/akkadianuser/logs/replica_init_process_aco.log
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo systemctl start aco-server"
            sleep 5
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo systemctl start tomcat"
        fi
done

sudo rm -Rf /home/akkadianuser/.sshpass_$ran

echo "ending replica configuration..." >> /home/akkadianuser/logs/replica_init_process_aco.log
date >> /home/akkadianuser/logs/set_mongo_replica.log