#!/usr/bin/env bash

COUNTER=0
isLB="False"
while [  $COUNTER -lt 1 ]; do
    pcsd_status=$(systemctl is-active --quiet pcsd && echo Service is running)
    pacemaker_status=$(systemctl is-active --quiet pacemaker && echo Service is running)
    corosync_status=$(systemctl is-active --quiet corosync && echo Service is running)

    if [[ "$pcsd_status" == "Service is running" && "$pacemaker_status" == "Service is running" && "$corosync_status" == "Service is running" ]]; then
        # shellcheck disable=SC2219
        let COUNTER=COUNTER+1
    else
        if [[ -f /home/akkadianuser/load_balancer.config ]]; then
            nodes=$(head -n 1 /home/akkadianuser/load_balancer.config)
            if [[ ! -v "${nodes}" ]]; then
                let COUNTER=COUNTER+1
                isLB="True"
            fi
        fi

    fi
    sleep 1
done

if [[ "$isLB" == "False" ]]; then
    MASTER=$(sudo pcs status | grep RS_VIP_Akkadian | awk -F ' ' '{print $4}')
    NODES=$(sudo pcs status | grep Online: | awk -F : '{print $2}')
    hostname=$(sudo hostname)
    IFS=$' '
else
    MASTER=$(sudo hostname)
    NODES=$(head -n 1 /home/akkadianuser/load_balancer.config)
    hostname=$(sudo hostname)
    IFS=$' '
fi

ran=$(( ( RANDOM % 100 )  + 1 ))
gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_aco.gpg > /home/akkadianuser/.sshpass_$ran

IFS=$' '
for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]
        then
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sh /home/akkadianuser/scripts/mongo_replica_scripts/remove_configs.sh"
        fi
done

sudo rm -Rf /home/akkadianuser/.sshpass_$ran
