#!/usr/bin/env bash

hostname=$(hostname)
echo "Removing mongod configurations on server named: $hostname"

sudo rm -Rf /home/akkadianuser/load_balancer.config

mongo admin -u mongoDBuser -p X46kTVmongo /home/akkadianuser/scripts/ha_aco/remove_secondaries.js
sleep 5
sudo yes | cp -Rf /home/akkadianuser/scripts/mongo_replica_scripts/start-mongo.sh /opt/akkadian/aco-server/scripts/start-mongodb.sh
result=$(sudo systemctl stop mongodb)
result=$(sudo systemctl start mongodb)
result=$(sudo systemctl status mongodb)

sleep 5
echo "+++++++++ Mongo status +++++++++++++"
echo "$result"
echo "++++++++++++++++++++++++++++++++++++"

echo "Trying to add user local db +++++++ "
mongo admin -u mongoDBuser -p X46kTVmongo /home/akkadianuser/scripts/ha_aco/add_user_local.js
sleep 3
echo "++++++++++++++++++++++++++++++++++++ "
echo "Trying to remove local db ++++++++++ "
mongo admin -u mongoDBuser -p X46kTVmongo /home/akkadianuser/scripts/ha_aco/drop_local_db.js
sleep 3
echo "++++++++++++++++++++++++++++++++++++ "

sudo truncate -s 0 /opt/akkadian/data/replica
sudo rm -Rf /opt/akkadian/data/replica
sudo yes | sudo cp -Rf  /home/akkadianuser/scripts/mongo_replica_scripts/applicationContext-mongo.xml /opt/tomcat/webapps/acow-webapp/WEB-INF/applicationContext-mongo.xml

sleep 5
result=$(sudo systemctl stop mongodb)
result=$(sudo systemctl start mongodb)
result=$(sudo systemctl status mongodb)
echo "+++++++++ Mongo status ====> "
echo "$result"
echo "++++++++++++++++++++++++++++++++++++"
sleep 5

sudo systemctl restart aco-server
sleep 3
systemctl restart tomcat

######## Opening port to receive sync from the other nodes
sudo firewall-cmd --remove-port=6789/tcp --permanent
sudo firewall-cmd --reload

sudo crontab -u akkadianuser -l | grep -v '/home/akkadianuser/scripts/ha_aco/get_data_folder_after_restart_and_restart_tomcat.sh'  | crontab -u akkadianuser -
sudo crontab -u akkadianuser -l | grep -v '/home/akkadianuser/mongo_recovery.lock' | sudo crontab -u akkadianuser -
sudo crontab -u akkadianuser -l | grep -v '/home/akkadianuser/scripts/ha_aco/if_master_down_new_master_sync.sh' | sudo crontab -u akkadianuser -