#!/usr/bin/env bash
echo "Adding mongo postconditions " >> /home/akkadianuser/logs/replica_init_process_aco.log
COUNTER=0
isLB="False"
while [  $COUNTER -lt 1 ]; do
    pcsd_status=$(systemctl is-active --quiet pcsd && echo Service is running)
    pacemaker_status=$(systemctl is-active --quiet pacemaker && echo Service is running)
    corosync_status=$(systemctl is-active --quiet corosync && echo Service is running)

    if [[ "$pcsd_status" == "Service is running" && "$pacemaker_status" == "Service is running" && "$corosync_status" == "Service is running" ]]; then
        let COUNTER=COUNTER+1
    else
        if [[ -f /home/akkadianuser/load_balancer.config ]]; then
            nodes=$(head -n 1 /home/akkadianuser/load_balancer.config)
            if [[ ! -v "${nodes}" ]]; then
                let COUNTER=COUNTER+1
                isLB="True"
            fi
        fi

    fi
    sleep 1
done

if [[ "$isLB" == "False" ]]; then
    MASTER=$(sudo pcs status | grep RS_VIP_Akkadian | awk -F ' ' '{print $4}')
    NODES=$(sudo pcs status | grep Online: | awk -F : '{print $2}')
    hostname=$(sudo hostname)
else
    MASTER=$(sudo hostname)
    NODES=$(head -n 1 /home/akkadianuser/load_balancer.config)
    hostname=$(sudo hostname)
fi

ran=$(( ( RANDOM % 100 )  + 1 ))

if [[ -d /opt/akkadian/aco-server ]]; then
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_aco.gpg > /home/akkadianuser/.sshpass_$ran
else
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_pme_cm.gpg > /home/akkadianuser/.sshpass_$ran
fi

echo "Adding crontab jobs" >> /home/akkadianuser/logs/replica_init_process_aco.log
for j in $NODES
do
    if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]];
    then
        echo "Inside the node: $j"
        #sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo crontab -u akkadianuser -l | grep -v '/home/akkadianuser/scripts/ha_aco/get_data_folder_after_restart_and_restart_tomcat.sh'  | crontab -u akkadianuser -"
        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo crontab -u akkadianuser -l | grep -v '/home/akkadianuser/scripts/ha_aco/if_master_down_new_master_sync.sh' | sudo crontab -u akkadianuser -"
        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo crontab -u akkadianuser -l | grep -v '/home/akkadianuser/mongo_recovery.lock' | sudo crontab -u akkadianuser -"
        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo crontab -u akkadianuser -l | grep -v '/home/akkadianuser/scripts/ha/write_master.sh' | sudo crontab -u akkadianuser -"

        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "(sudo crontab -u akkadianuser -l; echo \"* * * * *  /home/akkadianuser/scripts/ha_aco/if_master_down_new_master_sync.sh\" ) | sudo crontab -u akkadianuser -"
        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "(sudo crontab -u akkadianuser -l; echo \"@reboot  sudo rm -Rf /home/akkadianuser/mongo_recovery.lock\" ) | sudo crontab -u akkadianuser -"
        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "(sudo crontab -u akkadianuser -l; echo \"* * * * *  /home/akkadianuser/scripts/ha/write_master.sh\" ) | sudo crontab -u akkadianuser -"
        #sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "(sudo crontab -u akkadianuser -l; echo \"@reboot sleep 10 && /home/akkadianuser/scripts/ha_aco/get_data_folder_after_restart_and_restart_tomcat.sh\" ) | sudo crontab -u akkadianuser -"
    fi
done

sudo rm -Rf /home/akkadianuser/.sshpass_$ran