#!/usr/bin/env bash

echo $(date +%F_%T)" Checking if MariaDB has more than 20 transactional log files " > /var/log/checkmariadb.log

files=( /var/lib/mysql/master-bin.* )
if [[ ${#files[@]} -gt 20 ]]; then
	purge_to_file_path=${files[ ${#files[@]} - 7 ]}
	purge_to_file="$(basename $purge_to_file_path)"
    echo $(date +%F_%T) 'Files Count: ' ${#files[@]} ' too many MariaDB log files, purging to ' $purge_to_file  >> /var/log/checkmariadb.log
	mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "PURGE BINARY LOGS TO '$purge_to_file';" >> /var/log/checkmariadb.log
    echo $(date +%F_%T) 'MariaDB log purge completed' >> /var/log/checkmariadb.log
else
    echo $(date +%F_%T) 'MariaDB has less then 20 transactional log files, nothing to do ' >> /var/log/checkmariadb.log
fi