#!/usr/bin/env bash

LARAVEL_UPDATER_VERSION=1.21
AKKADIAN_SCRIPT_LIB_PATH="/home/akkadianuser/scripts"

LRED='\033[1;31m'
LBLUE='\033[1;34m'
LGREEN='\033[1;32m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color

#No params so show help message
if [[ $# -eq 0 ]]
then
    echo -e "\n${LGREEN}Laravel Updater v${LARAVEL_UPDATER_VERSION}${NC}"
    echo -e "${YELLOW}Usage: $0 update_file.zip 'theZipPwd' 'AppChecksum' /path/to/updatable/app${NC}\n"
    exit 0
fi

#Check arguments
if [[ -z $1 ]]
then
    echo -e "${LRED}Missing update zip file path parameter.${NC}"
    exit 1
fi

if [[ -z $2 ]]
then
    echo -e "${LRED}Missing zip file password parameter.${NC}"
    exit 1
fi

if [[ -z $3 ]]
then
    echo -e "${LRED}Missing app checksum parameter.${NC}"
    exit 1
fi

if [[ -z $4 ]]; then
    echo -e "${LRED}Missing app directory parameter.${NC}"
    exit 1;
fi


SOURCE_UPDATE_FILE_PATH=$1
ZIP_FILE_PASSWORD=$2
APP_CHECKSUM=$3
APP_DIRECTORY=$4

SOURCE_UPDATE_FILE_NAME=$(basename $1)
TEMP_UPDATE_FILE_PATH="/tmp/$SOURCE_UPDATE_FILE_NAME"
TEMP_UPDATE_DIRECTORY="/tmp/akkadian_updator/$(uuidgen)"
if [[ ! -d /tmp/akkadian_updator ]]; then
    sudo mkdir /tmp/akkadian_updator
fi

ARTISAN_CMD="php $APP_DIRECTORY/artisan"

#Make sure we don't start with stale data
echo -e "${LBLUE}Setting up temp dir '${YELLOW}$TEMP_UPDATE_DIRECTORY${NC}${LBLUE}'${NC}"
rm -rf "$TEMP_UPDATE_DIRECTORY"
rm -f "$TEMP_UPDATE_FILE_PATH"
mkdir -p "$TEMP_UPDATE_DIRECTORY"

#If we need to download the file
if [[ ( $SOURCE_UPDATE_FILE_PATH == "http"* ) || ( $SOURCE_UPDATE_FILE_PATH == "ftp"* ) ]]
then
    #Download update file to working directory
    echo -e "${LBLUE}Downloading source file...${NC}"
    wget "$SOURCE_UPDATE_FILE_PATH" -O "$TEMP_UPDATE_FILE_PATH"
else
    #Copy update file to working directory
    sudo cp "$SOURCE_UPDATE_FILE_PATH" "$TEMP_UPDATE_FILE_PATH"
fi

#Unzip
echo -e "${LBLUE}Unzipping update file...${NC}'"
unzip -o -P "$ZIP_FILE_PASSWORD" "$TEMP_UPDATE_FILE_PATH" -d "$TEMP_UPDATE_DIRECTORY"
VALIDATOR_FILE_NAME=project_validator.txt
BUNDLE_FILE_NAME=$(ls "$TEMP_UPDATE_DIRECTORY/"*.bundle | tail -1)

echo "$BUNDLE_FILE_NAME"
BUNDLE_FILE_NAME=$(basename "$BUNDLE_FILE_NAME")

#Verify validator file exists
if [[ ! -f $TEMP_UPDATE_DIRECTORY/$VALIDATOR_FILE_NAME ]]
then
    echo -e "${LRED}Update zip file is missing validator file.${NC}"
    exit 1
fi

#Verify bundle file exists
if [[ ! -f $TEMP_UPDATE_DIRECTORY/$BUNDLE_FILE_NAME ]]
then
    echo -e "${LRED}Update zip file is missing bundle file.${NC}"
    exit 1
fi

#Validate checksum
VALIDATOR_FILE_CHECKSUM=$(cat "$TEMP_UPDATE_DIRECTORY/$VALIDATOR_FILE_NAME" | tr -d "\n")
if [[ $VALIDATOR_FILE_CHECKSUM != $APP_CHECKSUM ]]
then
    echo -e "${LRED}Invalid update file. Checksum validation failed.${NC}"
    exit 1
fi

#Install bundle
$AKKADIAN_SCRIPT_LIB_PATH/installBundleUpdate.sh "$TEMP_UPDATE_DIRECTORY/$BUNDLE_FILE_NAME" "$APP_DIRECTORY"
if [[ $? != 0 ]]
then
    echo -e "${LRED}Failed to install bundle.${NC}";
    exit 1;
fi

#Update permissions
echo -e "${LBLUE}Updating Permissions...${NC}"
chown -R root:apache "$APP_DIRECTORY"
chmod -R 2775 "$APP_DIRECTORY"
chmod -R 2777 "$APP_DIRECTORY/storage"

#Clear cache
echo -e "${LBLUE}Clearing Cache...${NC}"
rm -f "$APP_DIRECTORY/bootstrap/cache/"*.php
$ARTISAN_CMD cache:clear
$ARTISAN_CMD view:clear
$ARTISAN_CMD config:clear
$ARTISAN_CMD route:clear

#Run migrations
echo -e "${LBLUE}Running migrations...${NC}"
$ARTISAN_CMD migrate --force

#Restart queue
echo -e "${LBLUE}Restarting queue...${NC}"
$ARTISAN_CMD queue:restart

#Optimize
echo -e "${LBLUE}Optimizing Laravel...${NC}"
$ARTISAN_CMD optimize

#Update permissions again in case migrations or
#queue restart commands modified/created files as current logged in user
echo -e "${LBLUE}Finalizing Permissions...${NC}"
chown -R root:apache "$APP_DIRECTORY"
chmod -R 2775 "$APP_DIRECTORY"
chmod -R 2777 "$APP_DIRECTORY/storage"

#Cleanup
echo -e "${LBLUE}Cleaning up...${NC}"
rm -rf "$TEMP_UPDATE_DIRECTORY"
rm -f "$TEMP_UPDATE_FILE_PATH"

echo -e "${LGREEN}Done.${NC}"