#!/bin/bash

# Add HIGH AVAILABILITY node script
#
# parameters:
# 			* Master node ip
#           * Slaves nodes ips (separated by -)
# 			* Virtual ip
# 			* Virtual ip Mask
echo "Starting HA setup process" > /home/akkadianuser/logs/ha_init_process.log
date >> /home/akkadianuser/logs/ha_init_process.log

IFS=$' '
CLUSTERNAME="CL_HA_Akkadian"
CLUSTERPASSWORD=$5
#"L3T\$W0RK2G3THER4now"
Virtual_IP_Resource_Name="RS_VIP_Akkadian"

nodes=$(echo $1 $2)

ran=$(( ( RANDOM % 100 )  + 1 ))
if [[ -d /opt/akkadian/aco-server ]]; then
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_aco.gpg > /home/akkadianuser/.sshpass_$ran
else
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_pme_cm.gpg > /home/akkadianuser/.sshpass_$ran
fi


echo "Installing password, enabling needed services in all nodes" >> /home/akkadianuser/logs/ha_init_process.log
for j in $nodes
    do
        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'echo '"$CLUSTERPASSWORD"' | passwd --stdin hacluster'
        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'systemctl restart pcsd.service'
        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'systemctl enable pcsd.service'
        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'systemctl enable corosync.service'
        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'systemctl enable pacemaker.service'
done

echo "Enabling HA..." >> /home/akkadianuser/logs/ha_init_process.log
sudo pcs cluster auth ${nodes} -u hacluster -p ${CLUSTERPASSWORD} --force
sudo pcs cluster setup --name ${CLUSTERNAME} ${nodes} --force
sudo pcs cluster start --all
sudo systemctl enable corosync.service
sudo systemctl enable pacemaker.service
sudo pcs property set stonith-enabled=false
sudo systemctl start corosync.service
sudo systemctl start pacemaker.service
sudo pcs resource create ${Virtual_IP_Resource_Name} ocf:heartbeat:IPaddr2 ip=$3  cidr_netmask=$4 op monitor interval=20s

for j in $nodes
    do
        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'systemctl enable corosync.service'
        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'systemctl enable pacemaker.service'
done

sudo rm -Rf /home/akkadianuser/.sshpass_$ran