#!/usr/bin/env bash
#/bin/bash
currenttime=date +"%r"

DateStamp=$(date +%d%m%y)
mkdir -p /opt/backup/$DateStamp
BackupDirectory=$(echo "/opt/backup/$DateStamp")
secondary=$(echo 'db.isMaster().secondary' | /opt/mongodb/bin/mongo)

if [[ echo $secondary | cut -d" " -f8 == "true" ]] ; then
    echo "use admin" | /opt/mongodb/bin/mongo
    echo "db.fsyncLock()" | /opt/mongodb/bin/mongo
    lock=$(echo 'db.currentOp().fsyncLock' | /opt/mongodb/bin/mongo)
    echo $lock

    if [[ echo $lock | cut -d" " -f8 == "true" ]] ; then
        rsync -avz /opt/mongodb $BackupDirectory
        if [[ $? == "0" ]] ; then
            echo "back up successful"
            echo "db.fsyncUnlock()" | /opt/mongodb/bin/mongo
            unlock=echo 'db.currentOp().fsyncLock' | /opt/mongodb/bin/mongo

            if [[ echo $unlock | cut -d" " -f8 == "bye" ]] ; then
                echo "db is successfully unlocked"
            else
                echo "$ip db is not unlocked " | mail -s "backup successfull but database not unlocked properly" abc.xyz@techaspect.com,xyz.abc@techaspect.com
            fi
        else
            echo "back up not successful"
        fi
    else
        echo "db is  not locked"
    fi

    cd /opt/backup
    tar -czvf mongobkp_$DateStamp.tar.gz $DateStamp
    rm -rf /opt/backup/$DateStamp
    aws s3 sync /opt/backup s3://mongo-backup-uat/ ; rm -f /opt/backup/*.tar.gz
else
    echo "database is not a secondary to take a backup"
fi