#!/usr/bin/env bash

ran=$(( ( RANDOM % 100 )  + 1 ))
function finish {
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_aco.gpg > /home/akkadianuser/.sshpass_$ran

    second=""
    for j in $NODES
        do
            if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]
            then
                nodes_len=$(($nodes_len+1))
                if [[ "$j" != "$MY_HOSTNAME" ]]; then
                    second=$j
                fi
            fi
    done

    echo "Cleaning lock" >> /home/akkadianuser/logs/mongo_recovery.log
    sudo rm -Rf /home/akkadianuser/mongo_recovery.lock

    sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second "sudo rm -Rf /home/akkadianuser/mongo_recovery.lock"

    echo "###################################### \n" >> /home/akkadianuser/logs/mongo_recovery.log
}

COUNTER=0
isLB="False"
while [  $COUNTER -lt 1 ]; do
    pcsd_status=$(systemctl is-active --quiet pcsd && echo Service is running)
    pacemaker_status=$(systemctl is-active --quiet pacemaker && echo Service is running)
    corosync_status=$(systemctl is-active --quiet corosync && echo Service is running)

    if [[ "$pcsd_status" == "Service is running" && "$pacemaker_status" == "Service is running" && "$corosync_status" == "Service is running" ]]; then
        let COUNTER=COUNTER+1
    else
        if [[ -f /home/akkadianuser/load_balancer.config ]]; then
            nodes=$(head -n 1 /home/akkadianuser/load_balancer.config)
            if [[ ! -v "${nodes}" ]]; then
                let COUNTER=COUNTER+1
                isLB="True"
            fi
        fi

    fi
    sleep 1
done

if [[ -d /opt/akkadian/aco-server ]]; then
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_aco.gpg > /home/akkadianuser/.sshpass_$ran
else
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_pme_cm.gpg > /home/akkadianuser/.sshpass_$ran
fi

echo "##### start processing heartbeat actions #####" >> /home/akkadianuser/logs/mongo_recovery.log
#ensure the change between replication is when there are more than 1 up and running
nodes_len=0
i=2
second=""
IFS=$' '
if [[ "$isLB" == "False" ]]; then
    MASTER=$(sudo pcs status | grep RS_VIP_Akkadian | awk -F ' ' '{print $4}')
    NODES=$(sudo pcs status | grep Online: | awk -F : '{print $2}')
    MY_HOSTNAME=$(sudo hostname)

    for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]
        then
            nodes_len=$(($nodes_len+1))
            if [[ "$j" != "$MY_HOSTNAME" ]]; then
                second=$j
            fi
        fi
    done

else
    MASTER=$(sh /home/akkadianuser/scripts/ha_aco/check_master_in_load_balancer_config.sh)
    uptime=$(sh /home/akkadianuser/scripts/ha_aco/get_uptime.sh)

    NODES=$(head -n 1 /home/akkadianuser/load_balancer.config)
    MY_HOSTNAME=$(sudo hostname)
    for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]
        then
            echo "trying to reach $j on 22"
            if [[ "$j" != "$MY_HOSTNAME" ]]; then
                isServerReachable=$(sh /home/akkadianuser/scripts/is_server_reachable_telnet.sh $j 22)
                if [[ "$isServerReachable" == "True" ]]; then
                    nodes_len=2
                    second=$j
                    MASTER2=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second "sh /home/akkadianuser/scripts/ha_aco/check_master_in_load_balancer_config.sh")
                    uptime2=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second "sh /home/akkadianuser/scripts/ha_aco/get_uptime.sh")
                else
                    nodes_len=1
                    second=""
                    MASTER2=""
                    uptime2=""
                fi
            fi
        fi
    done

    echo "node len: $nodes_len" >> /home/akkadianuser/logs/mongo_recovery.log
    if [[ $nodes_len == 1 ]]; then
        echo "Checking if changing node list is needed, only 1 node up" >> /home/akkadianuser/logs/mongo_recovery.log
        new_nodes=""
        echo "$NODES" >> /home/akkadianuser/logs/mongo_recovery.log
        first=""
        second=""
        for j in $NODES
        do
            if [[ "$j" == "$MY_HOSTNAME" ]]; then
                first=$j
            else
                second=$j
            fi
        done
        rm -Rf /home/akkadianuser/load_balancer.config
        > /home/akkadianuser/load_balancer.config
        echo "$first $second" > /home/akkadianuser/load_balancer.config
        echo "$first $second" >> /home/akkadianuser/logs/mongo_recovery.log

    else
        echo "MASTER: $MASTER" >> /home/akkadianuser/logs/mongo_recovery.log
        echo "MASTER2: $MASTER2" >> /home/akkadianuser/logs/mongo_recovery.log
        echo "uptime: $uptime" >> /home/akkadianuser/logs/mongo_recovery.log
        echo "uptime2: $uptime2" >> /home/akkadianuser/logs/mongo_recovery.log

        if [[ "$MASTER" != "$MASTER2" ]]; then
            echo "Masters are different" >> /home/akkadianuser/logs/mongo_recovery.log
            comp=$(sh /home/akkadianuser/scripts/math/comp.sh $uptime $uptime2)
            echo "comp: $comp" >> /home/akkadianuser/logs/mongo_recovery.log
            if [[ "$comp" == "True" ]]; then
                echo "Changing Master because we are recovering" >> /home/akkadianuser/logs/mongo_recovery.log
                #ensure all load_balancer.config files are synced
                rm -Rf /home/akkadianuser/load_balancer.config
                > /home/akkadianuser/load_balancer.config
                echo "$MASTER2 $MASTER" > /home/akkadianuser/load_balancer.config
                MASTER=$MASTER2
            fi
        fi
    fi
fi

recovering=$(sh /home/akkadianuser/scripts/ha_aco/is_recovering.sh)
recovering_second=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second "sh /home/akkadianuser/scripts/ha_aco/is_recovering.sh")

echo "recovering: $recovering" >> /home/akkadianuser/logs/mongo_recovery.log
echo "recovering_second: $recovering_second" >> /home/akkadianuser/logs/mongo_recovery.log

echo "nodes: $NODES" >> /home/akkadianuser/cli.log

if [[ $nodes_len -gt 1 && ("$recovering" != "yes") && ("$recovering_second" != "yes") ]]; then
    set -C; 2>/dev/null >/home/akkadianuser/mongo_recovery.lock
    sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second "set -C; 2>/dev/null >/home/akkadianuser/mongo_recovery.lock"
    trap finish EXIT
    echo "Setting trap" >> /home/akkadianuser/cli.log
elif [[ $nodes_len -eq 1 ]]; then
    sudo rm -Rf /home/akkadianuser/mongo_recovery.lock
    python email_client.py >> /home/akkadianuser/logs/mongo_recovery.log
else
    echo "Lock file exists… exiting" >> /home/akkadianuser/logs/mongo_recovery.log
    exit
fi

aco_version=$(cat /opt/akkadian/aco-server/wwwroot/version.js)

date >> /home/akkadianuser/logs/mongo_recovery.log
echo "node len: $nodes_len" >> /home/akkadianuser/logs/mongo_recovery.log

startMongoWithReplicaConfigs=$(sh /home/akkadianuser/scripts/ha_aco/mongo_replica_status_in_config_file.sh)
isReplicaRunning=$(sh /home/akkadianuser/scripts/ha_aco/mongo_replica_status.sh)
remote_mongo_status=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second "/home/akkadianuser/scripts/ha_aco/mongo_replica_status.sh")

echo "is replica running: $isReplicaRunning" >> /home/akkadianuser/logs/mongo_recovery.log
echo "replica config are in file: $startMongoWithReplicaConfigs" >> /home/akkadianuser/logs/mongo_recovery.log
echo "node list: $nodes_len" >> /home/akkadianuser/logs/mongo_recovery.log
echo "Remote mongo status is: $remote_mongo_status" >> /home/akkadianuser/logs/mongo_recovery.log


MASTER=$(echo "${MASTER##*( )}")
MASTER=$(echo "${MASTER%%*()}")
MASTER=$(echo "${MASTER//[$'\t\r\n ']}")
MY_HOSTNAME=$(echo "${MY_HOSTNAME##*( )}")
MY_HOSTNAME=$(echo "${MY_HOSTNAME%%*()}")
MY_HOSTNAME=$(echo "${MY_HOSTNAME//[$'\t\r\n ']}")

echo "master is: $MASTER" >> /home/akkadianuser/logs/mongo_recovery.log
echo "my_hostname is: $MY_HOSTNAME" >> /home/akkadianuser/logs/mongo_recovery.log


if [[ $nodes_len -gt 1 && "$startMongoWithReplicaConfigs" = "yes" && "$isReplicaRunning" = "no" ]]; then

    echo "replica config set, mongo not running" >> /home/akkadianuser/logs/mongo_recovery.log
    isNecessaryRm="False"
    the_other=""
    for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) && ("$j" != "$MY_HOSTNAME") && "$isNecessaryRm" = "False" ]]
        then
            echo "Trying to connect to $j" >> /home/akkadianuser/logs/mongo_recovery.log
            remote_mongo_status_config=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "/home/akkadianuser/scripts/ha_aco/mongo_replica_status_in_config_file.sh")
            remote_mongo_status=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "/home/akkadianuser/scripts/ha_aco/mongo_replica_status.sh")

            echo "remote_mongo_status_config: $remote_mongo_status_config" >> /home/akkadianuser/logs/mongo_recovery.log
            echo "remote_mongo_status: $remote_mongo_status" >> /home/akkadianuser/logs/mongo_recovery.log

            if [[ ("$remote_mongo_status_config" == "yes") && ("$remote_mongo_status" == "yes") ]]; then
                echo "Inside the if that enables the removing" >> /home/akkadianuser/logs/mongo_recovery.log
                isNecessaryRm="True"
                the_other=$j
            elif [[ ("$remote_mongo_status_config" == "yes") && ("$remote_mongo_status" == "no") ]]; then
                #means Other side is down also. So set this to standalone to start recovery
                echo "Reverting configs to be standalone" >> /home/akkadianuser/logs/mongo_recovery.log
                sudo systemctl stop mongodb
                sleep 5
                sudo cp -Rf /home/akkadianuser/scripts/mongo_replica_scripts/start-mongo.sh /opt/akkadian/aco-server/scripts/start-mongodb.sh
                echo "starting mongo without replication" >> /home/akkadianuser/logs/mongo_recovery.log
                sudo systemctl start mongodb
                sleep 10
                sudo truncate -s 0 /opt/akkadian/data/replica
                yes | sudo cp -Rf  /home/akkadianuser/scripts/mongo_replica_scripts/applicationContext-mongo.xml /opt/tomcat/webapps/acow-webapp/WEB-INF/applicationContext-mongo.xml

                sudo systemctl restart aco-server
                sleep 5
                sudo systemctl restart tomcat
            fi
        fi
    done

    if [[ "$isNecessaryRm" == "True" ]]; then

        echo "Removing local folder so it get latest data" >> /home/akkadianuser/logs/mongo_recovery.log
        sudo systemctl stop mongodb
        sleep 3
        #sudo rm -Rf /opt/akkadian/data/db/*
        #sleep 2
        sudo systemctl start mongodb

        nodes_to_write_replica=$(cat /home/akkadianuser/load_balancer.config)
        IF=' '
        initialization_string=''
        for j in $nodes_to_write_replica
        do
            if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]; then
                if [[ -z $initialization_string ]];
                then
                    echo "initialization_string empty"
                    initialization_string=$(echo "$j")
                else
                    initialization_string=$(echo "$initialization_string,$j")
                    echo "initialization_string not empty"
                fi
            fi
        done

        sudo sh /home/akkadianuser/scripts/ha_aco/send_hostname_to_replica.sh $initialization_string
        sleep 2

        sudo systemctl restart aco-server
        sleep 5
        sudo systemctl restart tomcat

    fi

#In fact I don't know if replication is down because user request
elif [[ $nodes_len -gt 1 && "$startMongoWithReplicaConfigs" = "no" ]]; then
    # This means we need to start mongo with replicaSet in it
    # configure all again???

    echo "Reverting back standalone config, because both  nodes are up" >> /home/akkadianuser/logs/mongo_recovery.log
    isnecessarychange="True"

    #means the other node has replica configured => the configuration in this node was turned off by this script
    if [[ "$isnecessarychange" = "True" ]];
    then

        echo "converting this node into part of replica" >> /home/akkadianuser/logs/mongo_recovery.log
        echo "stopping mongo" >> /home/akkadianuser/logs/mongo_recovery.log
        sudo systemctl stop mongodb
        echo "copying mongo file" >> /home/akkadianuser/logs/mongo_recovery.log
        sudo cp -Rf /home/akkadianuser/scripts/mongo_replica_scripts/start-mongo-replica.sh /opt/akkadian/aco-server/scripts/start-mongodb.sh
        sleep 5
        echo "starting mongo" >> /home/akkadianuser/logs/mongo_recovery.log
        sudo systemctl start mongodb

        sleep 3
        echo "hostname into /opt/akkadian/data/replica" >> /home/akkadianuser/logs/mongo_recovery.log

        nodes_to_write_replica=$(cat /home/akkadianuser/load_balancer.config)
        IF=' '
        initialization_string=''
        for j in $nodes_to_write_replica
        do
            if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]; then
                if [[ -z $initialization_string ]]; then
                    echo "initialization_string empty"
                    initialization_string=$(echo "$j")
                else
                    initialization_string=$(echo "$initialization_string,$j")
                    echo "initialization_string not empty"
                fi
            fi
        done
        echo "initialization_string: $initialization_string" >> /home/akkadianuser/logs/mongo_recovery.log

        sudo sh /home/akkadianuser/scripts/ha_aco/send_hostname_to_replica.sh $initialization_string
        nodes_comma_separated=$(cat /opt/akkadian/data/replica)
        yes | sudo cp -Rf /home/akkadianuser/scripts/mongo_replica_scripts/applicationContext-mongo_replicaSet.xml /tmp/applicationContext-mongo_replicaSet.xml
        sudo sed -i "s/list_of_nodes/$nodes_comma_separated/g" /tmp/applicationContext-mongo_replicaSet.xml
        yes | sudo cp -Rf /tmp/applicationContext-mongo_replicaSet.xml /opt/tomcat/webapps/acow-webapp/WEB-INF/applicationContext-mongo.xml

        echo "Restarting aco-server" >> /home/akkadianuser/logs/mongo_recovery.log

        sudo systemctl restart aco-server
        sleep 5
        sudo systemctl restart tomcat

        #this was master, and the other side can have un-sync the folder
        #sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second "rm -Rf /opt/akkadian/data/db/*"

    fi

elif [[ $nodes_len -eq 1 && "$startMongoWithReplicaConfigs" = "yes" ]]; then
    #revert every replica configuration in this node\

    echo "Reverting configs to be standalone" >> /home/akkadianuser/logs/mongo_recovery.log
    sudo systemctl stop mongodb
    sleep 5
    sudo cp -Rf /home/akkadianuser/scripts/mongo_replica_scripts/start-mongo.sh /opt/akkadian/aco-server/scripts/start-mongodb.sh
    echo "starting mongo without replication"
    sudo systemctl start mongodb
    sleep 10
    sudo truncate -s 0 /opt/akkadian/data/replica
    yes | sudo cp -Rf  /home/akkadianuser/scripts/mongo_replica_scripts/applicationContext-mongo.xml /opt/tomcat/webapps/acow-webapp/WEB-INF/applicationContext-mongo.xml

    sudo systemctl restart aco-server
    sleep 5
    sudo systemctl restart tomcat

    echo "yes" > /home/akkadinauser/recovering


elif [[ "$MASTER" == "$MY_HOSTNAME" && $nodes_len -gt 1 ]]; then

    echo "Checking if at least two nodes are up and running, if so, switch master" >> /home/akkadianuser/logs/mongo_recovery.log

    isnecessarychange="False"

    for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) && ("$j" != "$MY_HOSTNAME") && "$isnecessarychange" = "False" ]]
        then
            echo "Trying to connect to $j" >> /home/akkadianuser/logs/mongo_recovery.log
            remote_mongo_status_config=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "/home/akkadianuser/scripts/ha_aco/mongo_replica_status.sh")

            echo "remote_mongo_status_config: $remote_mongo_status_config" >> /home/akkadianuser/logs/mongo_recovery.log

            if [[ "$remote_mongo_status_config" == "yes" ]]; then
                isnecessarychange="True"
                echo "it is needed to convert this into part of replica" >> /home/akkadianuser/logs/mongo_recovery.log
            fi
        fi
    done

    if [[ "$isnecessarychange" == "True" ]]; then
            wasDifferent=$(mongo /home/akkadianuser/scripts/ha_aco/change_primary_node.js | tail -1)
            temp="${wasDifferent%\"}"
            temp="${temp#\"}"

            echo "hostname!==primary: $temp." >> /home/akkadianuser/logs/mongo_recovery.log
            if [[ "$temp" == "True" ]]; then
                echo "Master was not Primary, needed restart..." >> /home/akkadianuser/logs/mongo_recovery.log

                sudo systemctl restart aco-server
                sleep 5
                sudo systemctl restart tomcat

            else
                echo "Everything is good, do nothing" >> /home/akkadianuser/logs/mongo_recovery.log
                #sudo sh /home/akkadianuser/scripts/ha_aco/send_hostname_to_replica.sh
            fi

    elif [[ "$isReplicaRunning" = "yes" ]]; then
        echo "I'm Master, nodes>1, other nodes are not part of this cluster, trying to recovery them..." >> /home/akkadianuser/logs/mongo_recovery.log
        for j in $NODES
        do
            if [[ ( "$j" != "[" ) && ( "$j" != "]" ) && ("$j" != "$MY_HOSTNAME") ]]
            then
                echo "Trying to connect recover $j" >> /home/akkadianuser/logs/mongo_recovery.log
                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "systemctl stop mongodb"
                sleep 3
                #sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "rm -Rf /opt/akkadian/data/db/*"
                #sleep 2
                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "systemctl start mongodb"
                sleep 2

                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "systemctl restart aco-server"
                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "systemctl restart tomcat"
            fi
        done
    fi


elif [[ "$MASTER" != "$MY_HOSTNAME" && $nodes_len -gt 1 ]]; then
    echo "I am not master, all is good, it means I need to get last data just in case" >> /home/akkadianuser/logs/mongo_recovery.log

    sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$MASTER "tar -zcvf /home/akkadianuser/data.tar.gz /opt/akkadian/data/updates /opt/akkadian/data/template /opt/akkadian/data/published/csv"
    sshpass -f /home/akkadianuser/.sshpass_$ran scp -o StrictHostKeyChecking=no root@$MASTER:/home/akkadianuser/data.tar.gz /home/akkadianuser/data.tar.gz
    sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$MASTER "rm -Rf /home/akkadianuser/data.tar.gz"
    sudo tar -zxvf /home/akkadianuser/data.tar.gz -C /
    sudo rm -Rf /home/akkadianuser/data.tar.gz

    #sudo sh /home/akkadianuser/scripts/ha_aco/send_hostname_to_replica.sh
fi


sudo rm -Rf /home/akkadianuser/.sshpass_$ran

echo "removing lock file" >> /home/akkadianuser/logs/mongo_recovery.log

#move log file if needed.
sh /home/akkadianuser/scripts/ha_aco/check_ha_log_size.sh >> /home/akkadianuser/logs/mongo_recovery.log

echo "##### stop processing heartbeat actions #####" >> /home/akkadianuser/logs/mongo_recovery.log