#!/usr/bin/env bash

COUNTER=0
while [  $COUNTER -lt 1 ]; do
    pcsd_status=$(systemctl is-active --quiet pcsd && echo Service is running)
    pacemaker_status=$(systemctl is-active --quiet pacemaker && echo Service is running)
    corosync_status=$(systemctl is-active --quiet corosync && echo Service is running)

    if [[ "$pcsd_status" == "Service is running" && "$pacemaker_status" == "Service is running" && "$corosync_status" == "Service is running" ]]; then
        let COUNTER=COUNTER+1
    fi
    sleep 1
done

NODES=$(sudo pcs status | grep Online: | awk -F : '{print $2}')
MASTER=$(sudo pcs status | grep RS_VIP_Akkadian | awk -F ' ' '{print $4}')
MY_HOSTNAME=$(sudo hostname)

if [[ -d /opt/akkadian/aco-server ]]; then
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_aco.gpg > /home/akkadianuser/.sshpass_for_slave
else
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_pme_cm.gpg > /home/akkadianuser/.sshpass_for_slave
fi
IFS=$' '

#ensure the change between replication is when there are more than 1 up and running
nodes_len=0
for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]
        then
            nodes_len=$(($nodes_len+1))
        fi
done


isInFile=$(cat /opt/akkadian/aco-server/scripts/start-mongodb.sh | grep -c "aco_replica")
if [[ $isInFile -eq 0 ]]; then
   startMongoWithReplicaConfigs="no"
else
   startMongoWithReplicaConfigs="yes"
fi

sudo mongo admin -u mongoDBuser -p X46kTVmongo --eval "rs.status()" > /home/akkadianuser/mongoLastStatus
isInFileReplicaEnabled=$(cat /home/akkadianuser/mongoLastStatus | grep -c "NoReplicationEnabled")
if [[ $isInFileReplicaEnabled -eq 0 ]]; then
   isReplicaRunning="yes"
else
   isReplicaRunning="no"
fi

if [[ $nodes_len > 1 && "$startMongoWithReplicaConfigs" = "yes" && "$isReplicaRunning" = "yes" ]]; then

    echo "replica config set, mongo not running" >> /home/akkadianuser/cli.log
    isNecessaryRm="False"
    for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) && ("$j" != "$MY_HOSTNAME") && "$isNecessaryRm" = "False" ]]
        then
            nodewas1=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "grep -R aco_replica /opt/akkadian/aco-server/scripts/start-mongodb.sh")
            if [[ "$nodewas1" != "" ]]; then
                isNecessaryRm="True"
            fi
        fi
    done

    if [[ "$isNecessaryRm" = "True" ]]; then
        sudo systemctl stop mongodb
        sleep 5
        sudo rm -Rf /opt/akkadian/data/db/*
        sudo systemctl start mongodb
    fi
fi

truncate -s 0 /home/akkadianuser/.sshpass_for_slave
sudo rm -Rf /home/akkadianuser/.sshpass_for_slave