#!/usr/bin/env bash

MY_HOSTNAME=$(sudo hostname)
STATUS=$(sudo pcs status | grep pcsd | awk -F ' ' '{print $2}')

if [[ "$STATUS" == "active/enabled" ]]; then
        MASTER=$(sudo pcs status | grep Started | awk -F ' ' '{print $4}')

        sudo echo "$MASTER" > /var/www/html/ha/master

else
    #if there is an external load balancer
    if [[ -f /home/akkadianuser/load_balancer.config ]]; then
        fake_master=$(head -n 1 /home/akkadianuser/load_balancer.config | awk '{print $1;}')
        if [[ "$fake_master" == "$MY_HOSTNAME" ]]; then
            sudo echo "$fake_master" > /var/www/html/ha/master
        else
            isServerReachable=$(sh /home/akkadianuser/scripts/is_server_reachable_telnet.sh $fake_master 22)
            if [[ $isServerReachable != "True" ]]; then
              sudo echo "$MY_HOSTNAME" > /var/www/html/ha/master
            else
              sudo truncate -s 0 /var/www/html/ha/master
            fi
        fi
    else
        echo "non-ha-env" > /var/www/html/ha/master
    fi

fi