#!/usr/bin/env bash

ran=$(((RANDOM % 100) + 1))

if [[ -d /opt/akkadian/aco-server ]]; then
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_aco.gpg >/home/akkadianuser/.sshpass_$ran
else
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_pme_cm.gpg >/home/akkadianuser/.sshpass_$ran
fi

IFS=$' '
NODES=$(head -n 1 /home/akkadianuser/load_balancer.config)
MY_HOSTNAME=$(sudo hostname)

for j in $NODES; do
    if [[ ("$j" != "[") && ("$j" != "]") ]]; then
        if [[ "$j" != "$MY_HOSTNAME" ]]; then
            isServerReachable=$(sh /home/akkadianuser/scripts/is_server_reachable_telnet.sh $j 22)
            if [[ "$isServerReachable" == "True" ]]; then
                product_name=$(sh /home/akkadianuser/scripts/universal_updater/get_product_name.sh)

                function sync() {
                    sshpass -f /home/akkadianuser/.sshpass_$ran rsync -avzu -e "ssh -o StrictHostKeyChecking=no" "$2" root@"$1":"$2"
                }

                function sync_apm() {
                    sync "$j" /var/www/html/pme/media/selfservice/images/branding/
                    sync "$j" /var/www/html/pme/media/images/branding/
                    sync "$j" /var/www/html/pme/media/cert/
                    sync "$j" /var/www/html/pme/phonecontrol_image_upload/
                    sync "$j" /var/www/html/pme/media/php-saml/certs/
                    sync "$j" /etc/openldap/certs/
                }

                function sync_acm() {
                    sync "$j" /var/www/html/acm/application/csv_uploads/
                    sync "$j" /var/www/html/acm/media/photos/
                    sync "$j" /etc/openldap/certs/
                }

                function sync_orc() {
                    sync "$j" /var/www/html/orc/storage/branding/
                    sync "$j" /var/www/html/orc/storage/oauth-private.key
                    sync "$j" /var/www/html/orc/storage/oauth-public.key
                }

                function sync_asb() {
                    sync "$j" /var/www/html/asb/storage/app/public/branding/
                    sync "$j" /var/www/html/asb/storage/csv/
                    sync "$j" /var/www/html/asb/storage/database/
                    sync "$j" /var/www/html/asb/storage/json/
                    sync "$j" /var/www/html/asb/storage/oauth-private.key
                    sync "$j" /var/www/html/asb/storage/oauth-public.key
                }

                if [[ "$product_name" == "hcs" ]]; then
                    sync_apm
                    sync_orc
                    sync_asb
                elif [[ "$product_name" == "apm" ]]; then
                    sync_apm
                elif [[ "$product_name" == "acm" ]]; then
                    sync_acm
                elif [[ "$product_name" == "orc" ]]; then
                    sync_orc
                elif [[ "$product_name" == "asb" ]]; then
                    sync_asb
                fi
            fi
        fi
    fi
done

rm -Rf /home/akkadianuser/.sshpass_$ran
