#!/usr/bin/env bash

echo "Starting galera based replication... " > /home/akkadianuser/logs/replica_init_process.log

hostname=$(sudo hostname)
NODES=$(head -n 1 /home/akkadianuser/load_balancer.config)

ran=$(( ( RANDOM % 100 )  + 1 ))

if [[ -d /opt/akkadian/aco-server ]]; then
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_aco.gpg > /home/akkadianuser/.sshpass_$ran
else
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_pme_cm.gpg > /home/akkadianuser/.sshpass_$ran
fi
IFS=$' '

nodes_comma_separated=$(echo ${NODES// /,})
nodes_comma_separated=$(echo "${nodes_comma_separated:1}")

echo "nodes: $nodes_comma_separated" >> /home/akkadianuser/logs/replica_init_process.log

#Before anything match the data bases
echo "Dumping db" >> /home/akkadianuser/logs/replica_init_process.log
mysqldump --defaults-extra-file=/home/akkadianuser/.my.cnf --max_allowed_packet=1G --events --add-drop-database --add-drop-table --databases asb call_manager maestro ucce unity_connection pme > /home/akkadianuser/masterdatabase.sql

sleep 5
for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) && ("$j" != "$hostname") ]]; then
            echo "Restoring db into $j" >> /home/akkadianuser/logs/replica_init_process.log
            sshpass -f /home/akkadianuser/.sshpass_$ran scp -o StrictHostKeyChecking=no /home/akkadianuser/masterdatabase.sql root@$j:/home/akkadianuser/dbstosync/masterdatabase.sql
            sleep 3
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf < /home/akkadianuser/dbstosync/masterdatabase.sql'
        fi
done
sleep 5


#ensure the change between replication is when there are more than 1 up and running
echo "modify local cnf file" >> /home/akkadianuser/logs/replica_init_process.log
nodes_len=0
for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]
        then
	        echo "modify_local with $nodes_comma_separated and $j" >> /home/akkadianuser/logs/replica_init_process.log
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sh /home/akkadianuser/scripts/ha/replication_new_galera_approach/modify_local_cnf.sh $nodes_comma_separated $j"
        fi
done
sleep 2

#Initialize the first node as bootstrap
echo "Initialize with galera_new_cluster" >> /home/akkadianuser/logs/replica_init_process.log
go_next="True"
for j in $NODES
    do
	echo "Processing $j"
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]
        then
            if [[ "$go_next" == "True" ]]; then
		        echo "Trying to bootstrap $j" >> /home/akkadianuser/logs/replica_init_process.log
                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo systemctl stop mariadb"
                sleep 3
                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo galera_new_cluster"
                sleep 3
                status=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo systemctl status mariadb")
		        echo "status is: $status"
                if [[ "$status" == *"[ERROR] WSREP: It may not be safe to bootstrap the cluster from this node"*  ||
                        "$status" == *"[ERROR] WSREP: gcs connect failed: Connection timed out"* ]]; then
                    echo "The boostrapping action failed for $j, going next" >> /home/akkadianuser/logs/replica_init_process.log
                    go_next="True"
                else
		            echo "The bootstraped node is: $j" >> /home/akkadianuser/logs/replica_init_process.log
                    bootstraped_node=$j
                    go_next="False"
                fi
            fi
        fi
done

for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]
        then
            if [[ "$j" != "$bootstraped_node" ]]; then
                echo "Initializing the other nodes as normal in: $j" >> /home/akkadianuser/logs/replica_init_process.log
                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@"$j" "sudo systemctl start mariadb"
            fi
        fi
done

for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]
        then
            echo "Adding galera post-conditions into $j" >> /home/akkadianuser/logs/replica_init_process.log
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@"$j" "sh /home/akkadianuser/scripts/ha/replication_new_galera_approach/install_replica_failover_service.sh"
        fi
done

for j in $NODES; do
    if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]; then
        echo "Adding sync_folders_with_rsync script to crontab $j" >> /home/akkadianuser/logs/replica_init_process.log
        line="*/30 * * * * /bin/bash /home/akkadianuser/scripts/ha/replication_new_galera_approach/sync_folders_with_rsync.sh"
        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "(sudo crontab -u akkadianuser -l; echo \"$line\" ) | sudo crontab -u akkadianuser -"
    fi
done

####### This is a workaround to have replica failover module recovering without restarting the nodes ############
sleep 5
for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]
        then
            echo "Restarting replica failover module in $j" >> /home/akkadianuser/logs/replica_init_process.log
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@"$j" "sudo systemctl stop replica-failover"
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@"$j" "sleep 3"
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@"$j" "sudo systemctl start replica-failover"
        fi
done

######## Ending workaround ###################################################################################

#I move this here in order to keep the process of setting up replication separated from HA, it could be in the las for also.
for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]
        then
            echo "Copying over supervisord configuration files for ha on $j" >> /home/akkadianuser/logs/replica_init_process.log
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@"$j" "sh /home/akkadianuser/scripts/ha/replication_new_galera_approach/supervisor_beanstalk_configurator_with_ha.sh"
        fi
done
