#!/usr/bin/env bash
hostname=$(sudo hostname)
NODES=$(head -n 1 /home/akkadianuser/load_balancer.config)

ran=$(( ( RANDOM % 100 )  + 1 ))

if [[ -d /opt/akkadian/aco-server ]]; then
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_aco.gpg > /home/akkadianuser/.sshpass_$ran
else
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_pme_cm.gpg > /home/akkadianuser/.sshpass_$ran
fi

IFS=$' '

echo "Removing configurations from: $NODES"
for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]
        then
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo systemctl stop mariadb"
            sleep 3
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo rm -Rf /etc/my.cnf.d/galera.cnf"

            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo crontab -u akkadianuser -l | grep -v 'sh /home/akkadianuser/scripts/ha/replication_new_galera_approach/galera_postcondition_at_reboot.sh'  | crontab -u akkadianuser -"
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo crontab -u akkadianuser -l | grep -v 'sh /home/akkadianuser/scripts/ha/replication_new_galera_approach/galera_postcondition_per_minute.sh'  | crontab -u akkadianuser -"

        fi
done

sleep 5

for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]
        then
             sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo systemctl restart mariadb"
        fi
done

for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]
        then
             sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sh /home/akkadianuser/scripts/replication/new_galera_approach/uninstall_replica_failover_service.sh"
        fi
done

for j in $NODES; do
    if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]; then
        echo "Removing sync_folders_with_rsync script from crontab $j" >> /home/akkadianuser/logs/replica_init_process.log
        line="*/30 * * * * /bin/bash /home/akkadianuser/scripts/ha/replication_new_galera_approach/sync_folders_with_rsync.sh"
        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$"j" "sudo crontab -u akkadianuser -l | grep -v \"$line\" | sudo crontab -u akkadianuser -"
    fi
done

#sh /home/akkadianuser/scripts/ha/replication_new_galera_approach/supervisor_beanstalk_configurator_with_non_ha.sh

for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]
        then
            echo "Copying over supervisord configuration files for non-ha on $j" >> /home/akkadianuser/logs/replica_init_process.log
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sh /home/akkadianuser/scripts/ha/replication_new_galera_approach/supervisor_beanstalk_configurator_with_non_ha.sh"
        fi
done

rm -Rf /home/akkadianuser/.sshpass_$ran