echo "Init recovery process " > /home/akkadianuser/logs/galera_recovery.log
ran=$(( ( RANDOM % 100 )  + 1 ))

if [[ -d /opt/akkadian/aco-server ]]; then
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_aco.gpg > /home/akkadianuser/.sshpass_$ran
else
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_pme_cm.gpg > /home/akkadianuser/.sshpass_$ran
fi
nodes_len=0
  IFS=$' '
  NODES=$(head -n 1 /home/akkadianuser/load_balancer.config)
  MY_HOSTNAME=$(sudo hostname)

for j in $NODES
do
  if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]
  then
    nodes_len=$(($nodes_len+1))
  fi
done

isRemoteGaleraRecovering="False"

if [[ $nodes_len == 2 ]]; then
      for j in $NODES
      do
          if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]
          then
              echo "trying to reach $j on 22" >> /home/akkadianuser/logs/galera_recovery.log
              if [[ "$j" != "$MY_HOSTNAME" ]]; then
                isRemoteGaleraRecovering=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sh /home/akkadianuser/scripts/ha/replication_new_galera_approach/is_galera_recovering.sh")
                echo "Remote node is trying to recovery: $isRemoteGaleraRecovering" >> /home/akkadianuser/logs/galera_recovery.log
              fi
          fi
      done
fi

if [[ "$isRemoteGaleraRecovering" != "True" ]]; then

    echo "Adding lock file" >> /home/akkadianuser/logs/galera_recovery.log
    set -C; 2>/dev/null >/home/akkadianuser/galera_postcondition_is_running.lock
    times=$(head -n 1 /home/akkadianuser/send_email_numbers)

    didSetIgnore=$(mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "SHOW VARIABLES LIKE 'wsrep_provider_options';" | grep -o "pc.ignore_sb = TRUE")
    if [[ "$didSetIgnore" == "pc.ignore_sb = TRUE" ]]; then
        didIReach="False"
    else
        didIReach="True"
    fi


    if [[ $nodes_len == 2 ]]; then
        for j in $NODES
        do
              if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]; then
                  echo "trying to reach $j on 22"
                  if [[ "$j" != "$MY_HOSTNAME" ]]; then
                      isServerReachable=$(sh /home/akkadianuser/scripts/is_server_reachable_telnet.sh $j 22)
                      current_isMariaDbActive=$(sh /home/akkadianuser/scripts/ha/replication_new_galera_approach/is_mariadb_active.sh)
                      remote_isMariaDbActive=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sh /home/akkadianuser/scripts/ha/replication_new_galera_approach/is_mariadb_active.sh")

                      bothMariaDbDown="False"

                      if [[ "$isServerReachable" == "True" ]]; then

                          if [[ "$current_isMariaDbActive" == "True" && "$remote_isMariaDbActive" == "True" ]]; then
                               echo "Everything seems to be ok, do nothing..." >> /home/akkadianuser/logs/galera_recovery.log
#                              echo "Everything seems to be ok, do nothing..." >> /home/akkadianuser/logs/galera_recovery.log
#                              check_status_node1=$(sh /home/akkadianuser/scripts/ha/replication_new_galera_approach/get_galera_recovery_status.sh)
#                              check_status_node2=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sh /home/akkadianuser/scripts/ha/replication_new_galera_approach/get_galera_recovery_status.sh")
#                              check_cluster_size_node1=$(sh /home/akkadianuser/scripts/ha/replication_new_galera_approach/check_cluster_size.sh)
#                              check_cluster_size_node2=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sh /home/akkadianuser/scripts/ha/replication_new_galera_approach/check_cluster_size.sh")
#
#                              echo "status node1 and node 2: $check_status_node1, $check_status_node2, $check_cluster_size_node1, $check_cluster_size_node2" >> /home/akkadianuser/logs/galera_recovery.log
#                              if [[ "$check_status_node1" != "Primary" || "$check_status_node2" != "Primary"
#                                    || "$check_cluster_size_node1" != "2" || "$check_cluster_size_node2" != "2" ]]; then
#                                  this_commit=$(sh /home/akkadianuser/scripts/ha/replication_new_galera_approach/get_galera_current_commit_number.sh)
#                                  that_commit=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sh /home/akkadianuser/scripts/ha/replication_new_galera_approach/get_galera_current_commit_number.sh")
#                                  echo "this and that commit: $this_commit, $that_commit" >> /home/akkadianuser/logs/galera_recovery.log
#                                  bootstrapper_node=""
#                                  comp=$(sh /home/akkadianuser/scripts/math/comp.sh $this_commit $that_commit)
#                                  echo "comp: $comp" >> /home/akkadianuser/logs/galera_recovery.log
#                                  if [[ "$comp" == "True" ]]; then
#                                      bootstrapper_node=$j
#                                  else
#                                      bootstrapper_node=$MY_HOSTNAME
#                                  fi
#                                  echo "bootstrapper_node: $bootstrapper_node" >> /home/akkadianuser/logs/galera_recovery.log
#                                  sh /home/akkadianuser/scripts/ha/replication_new_galera_approach/kill_mariadb.sh
#                                  sleep 5
#                                  sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sh /home/akkadianuser/scripts/ha/replication_new_galera_approach/kill_mariadb.sh"
#                                  sleep 5
#
#                                  if [[ "$bootstrapper_node" == "$MY_HOSTNAME" ]]; then
#                                      galera_new_cluster
#                                      sleep 5
#                                      sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "systemctl start mariadb"
#                                      sleep 5
#                                  else
#                                      sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "galera_new_cluster"
#                                      sleep 5
#                                      systemctl start mariadb
#                                      sleep 5
#                                  fi
#                              fi
                          elif [[ "$current_isMariaDbActive" == "True" && "$remote_isMariaDbActive" == "False" ]]; then
                              #try first rebooting normally remote
                              sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "systemctl start mariadb"
                              sleep 5
                              status=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "systemctl status mariadb")
                              if [[ "$status" == *"[ERROR] WSREP: It may not be safe to bootstrap the cluster from this node"*  ||
                                    "$status" == *"[ERROR] WSREP: gcs connect failed: Connection timed out"* ]]; then

                                  echo "trying to force bootstap through the file grastate.dat" >> /home/akkadianuser/logs/galera_recovery.log
                                  sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo sed -i "/safe_to_bootstrap/s/0/1/" /var/lib/mysql/grastate.dat"
                                  sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo galera_new_cluster"
                                  sleep 10

                                  status=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "systemctl status mariadb")
                                  if [[ "$status" == *"[ERROR] WSREP: It may not be safe to bootstrap the cluster from this node"*  ||
                                        "$status" == *"[ERROR] WSREP: gcs connect failed: Connection timed out"* ]]; then

                                      #trying to switch
                                      sh /home/akkadianuser/scripts/ha/replication_new_galera_approach/kill_mariadb.sh
                                      sleep 3
                                      sudo sed -i "/safe_to_bootstrap/s/0/1/" /var/lib/mysql/grastate.dat
                                      galera_new_cluster
                                      sleep 5
                                      status=$(systemctl status mariadb)
                                      if [[ "$status" == *"[ERROR] WSREP: It may not be safe to bootstrap the cluster from this node"*  ||
                                            "$status" == *"[ERROR] WSREP: gcs connect failed: Connection timed out"* ]]; then

                                            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'sudo sed -i "/safe_to_bootstrap/s/0/1/" /var/lib/mysql/grastate.dat'
                                            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "galera_new_cluster"
                                            sleep 5
                                            systemctl start mariadb
                                            sleep 5
                                      fi
                                  fi

                              fi
                          elif [[ "$current_isMariaDbActive" == "False" && "$remote_isMariaDbActive" == "True" ]]; then

                              systemctl start mariadb
                              sleep 5
                              status=$(systemctl status mariadb)
                              if [[ "$status" == *"[ERROR] WSREP: It may not be safe to bootstrap the cluster from this node"*  ||
                                    "$status" == *"[ERROR] WSREP: gcs connect failed: Connection timed out"* ]]; then

                                  #it fails, but the other side is up, trying with galera_new_cluster
                                  sudo sed -i "/safe_to_bootstrap/s/0/1/" /var/lib/mysql/grastate.dat
                                  galera_new_cluster
                                  sleep 5
                                  status=$(systemctl status mariadb)
                                  if [[ "$status" == *"[ERROR] WSREP: It may not be safe to bootstrap the cluster from this node"*  ||
                                      "$status" == *"[ERROR] WSREP: gcs connect failed: Connection timed out"* ]]; then

                                      sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sh /home/akkadianuser/scripts/ha/replication_new_galera_approach/kill_mariadb.sh"
                                      sleep 3

                                      sudo sed -i "/safe_to_bootstrap/s/0/1/" /var/lib/mysql/grastate.dat
                                      galera_new_cluster
                                      sleep 5
                                      status=$(systemctl status mariadb)
                                      if [[ "$status" == *"[ERROR] WSREP: It may not be safe to bootstrap the cluster from this node"*  ||
                                            "$status" == *"[ERROR] WSREP: gcs connect failed: Connection timed out"* ]]; then

                                            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'sudo sed -i "/safe_to_bootstrap/s/0/1/" /var/lib/mysql/grastate.dat'
                                            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "galera_new_cluster"
                                            sleep 5
                                            systemctl start mariadb
                                      else
                                          sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "systemctl start mariadb"
                                      fi
                                  fi
                              fi

                          elif [[ "$current_isMariaDbActive" == "False" && "$remote_isMariaDbActive" == "False" ]]; then
                              # stop all previous tries!!! in case it is stuck
                              sh /home/akkadianuser/scripts/ha/replication_new_galera_approach/kill_mariadb.sh
                              sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sh /home/akkadianuser/scripts/ha/replication_new_galera_approach/kill_mariadb.sh"
                              #sleep 3
                              galera_new_cluster
                              sleep 5
                              status=$(systemctl status mariadb)
                              if [[ "$status" == *"[ERROR] WSREP: It may not be safe to bootstrap the cluster from this node"*  ||
                                    "$status" == *"[ERROR] WSREP: gcs connect failed: Connection timed out"* ]]; then
                                    sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'sudo sed -i "/safe_to_bootstrap/s/0/1/" /var/lib/mysql/grastate.dat'
                                    sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "galera_new_cluster"
                                    sleep 5
                                    systemctl start mariadb
                              else
                                    sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "systemctl start mariadb"
                              fi
                          fi
                      else
                          echo "False" > /home/akkadianuser/was_other_side_reachable

                          if [[ "$current_isMariaDbActive" == "False" ]]; then
                              sudo sed -i "/safe_to_bootstrap/s/0/1/" /var/lib/mysql/grastate.dat
                              galera_new_cluster
                              sleep 5
                              status=$(systemctl status mariadb)
                              if [[ "$status" == *"[ERROR] WSREP: It may not be safe to bootstrap the cluster from this node"*  ||
                                    "$status" == *"[ERROR] WSREP: gcs connect failed: Connection timed out"* ]]; then
                                        systemctl start mariadb
                              fi
                          else
                              mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "SET GLOBAL wsrep_provider_options='pc.bootstrap=YES';"
                              mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "SET GLOBAL wsrep_provider_options='pc.ignore_sb=TRUE';"
                          fi

                          if [[ ! -z "$times" && "$times" == "5" ]]; then
                              echo "trying to send the email" >> /home/akkadianuser/logs/galera_recovery.log
                              python email_client.py >> /home/akkadianuser/logs/mariadb_ha.log
                              sudo rm -Rf /home/akkadianuser/send_email_numbers
                          elif [[ -z "$times" ]]; then
                              sudo echo "1" > /home/akkadianuser/send_email_numbers
                          else
                              times=$(($times+1))
                              sudo echo $times > /home/akkadianuser/send_email_numbers
                          fi
                      fi
                fi
            fi
        done
  fi

  rm -Rf /home/akkadianuser/.sshpass_$ran
  sudo rm -Rf /home/akkadianuser/galera_postcondition_is_running.lock
fi