#!/usr/bin/env bash
echo "Starting Replication master master" > /home/akkadianuser/logs/replica_init_process.log
date >> /home/akkadianuser/logs/replica_init_process.log

ran=$(( ( RANDOM % 100 )  + 1 ))
gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_pme_cm.gpg > /home/akkadianuser/.sshpass_$ran

hostname=$(hostname)

if [[ "$hostname" = "$1" ]]; then
    other=$2
else
    other=$1
fi

echo "$other"
> /home/akkadianuser/load_balancer.config
echo "$hostname $other" > /home/akkadianuser/load_balancer.config
sudo firewall-cmd --permanent --add-port=3306/tcp
sudo firewall-cmd --reload

isServerReachable=$(sh /home/akkadianuser/scripts/is_server_reachable_telnet.sh $other 22)
if [[ ! "$isServerReachable" == "True" ]]; then
  echo "The second node is not reachable, cannot continue" >> /home/akkadianuser/logs/replica_init_process.log
  exit 1
fi

echo "Writing remote load_balancer file" >> /home/akkadianuser/logs/replica_init_process.log
sshpass -f /home/akkadianuser/.sshpass_$ran scp -o StrictHostKeyChecking=no /home/akkadianuser/load_balancer.config root@$other:/home/akkadianuser/load_balancer.config

echo "Open remote port" >> /home/akkadianuser/logs/replica_init_process.log

sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$other "firewall-cmd --permanent --add-port=3306/tcp"
sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$other "firewall-cmd --reload"

truncate -s 0 /home/akkadianuser/.sshpass_$ran
sudo rm -Rf /home/akkadianuser/.sshpass_$ran