#!/usr/bin/env bash

echo "Running post-conditions" >> /home/akkadianuser/logs/replica_init_process.log

hostname=$(sudo hostname)
nodes=$(head -n 1 /home/akkadianuser/load_balancer.config)
for node in $nodes; do
    if [[ "$node" != "$hostname" ]]
    then
        second_master=$node
    fi
done

isServerReachable=$(sh /home/akkadianuser/scripts/is_server_reachable_telnet.sh $second_master 22)
if [[ ! "$isServerReachable" == "True" ]]; then
  echo "The second node is not reachable, cannot continue" >> /home/akkadianuser/logs/replica_init_process.log
  exit 1
fi

ran=$(( ( RANDOM % 100 )  + 1 ))

if [[ -d /opt/akkadian/aco-server ]]; then
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_aco.gpg > /home/akkadianuser/.sshpass_$ran
else
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_pme_cm.gpg > /home/akkadianuser/.sshpass_$ran
fi

echo "Adding post-conditions to crontab" >> /home/akkadianuser/logs/replica_init_process.log
sudo crontab -u akkadianuser -l | grep -v '/home/akkadianuser/scripts/ha/get_masterdb_to_master_noha.sh'  | crontab -u akkadianuser -
(sudo crontab -u akkadianuser -l; echo "@reboot /home/akkadianuser/scripts/ha/get_masterdb_to_master_noha.sh" ) | sudo crontab -u akkadianuser -
(sudo crontab -u akkadianuser -l; echo "* * * * * /home/akkadianuser/scripts/ha/get_masterdb_to_master_noha.sh" ) | sudo crontab -u akkadianuser -

sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master "sudo crontab -u akkadianuser -l | grep -v '/home/akkadianuser/scripts/ha/get_masterdb_to_master_noha.sh'  | crontab -u akkadianuser -"
sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master "(sudo crontab -u akkadianuser -l; echo \"@reboot /home/akkadianuser/scripts/ha/get_masterdb_to_master_noha.sh \" ) | sudo crontab -u akkadianuser -"
sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master "(sudo crontab -u akkadianuser -l; echo \"* * * * * /home/akkadianuser/scripts/ha/get_masterdb_to_master_noha.sh \" ) | sudo crontab -u akkadianuser -"

truncate -s 0 /home/akkadianuser/.sshpass_$ran
sudo rm -Rf /home/akkadianuser/.sshpass_$ran