#!/usr/bin/env bash

if [[ -d /opt/akkadian/aco-server ]]; then
    a=$(sh /home/akkadianuser/scripts/ha_aco/mongo_replica_status.sh)
    b=$(sh /home/akkadianuser/scripts/ha_aco/mongo_replica_status_in_config_file.sh)

    if [[ "$a" == "yes" && "$b" == "yes" ]];then
        echo "True"
    else
        echo "False"
    fi
    exit 0

else
    isRunning=$(sh /home/akkadianuser/scripts/ha/replication_new_galera_approach/check_galera_replication_status.sh)
    if [[ ! -z "$isRunning" ]];then
        echo "True"
        exit 0
    else
        pcsd_status=$(pcs status 2>&1)
        if [[ "$pcsd_status" != "Error: cluster is not currently running on this node" ]]
        then
            MASTER=$(sudo pcs status | grep RS_VIP_Akkadian | awk -F ' ' '{print $4}')
            NODES=$(sudo pcs status | grep Online: | awk -F : '{print $2}')

            gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_pme_cm.gpg > /home/akkadianuser/.sshpass
            IFS=$' '
            r=""
            for j in $NODES
                do
                    if [[ ( "$j" != "[" ) && ( "$j" != "]" ) && ("$j" != "$MASTER") ]]
                    then
                        r=$(sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "SHOW SLAVE STATUS\G;" | grep "Master_Host\|Slave_IO_Running"')
                    fi
            done
            truncate -s 0 /home/akkadianuser/.sshpass
            sudo rm -Rf /home/akkadianuser/.sshpass

            if grep -q "Slave_IO_Running" <<< "$r"; then
                echo "True"
                exit 0
            fi

        else
            if [[ -f /home/akkadianuser/load_balancer.config ]]; then
                NODES=$(head -n 1 /home/akkadianuser/load_balancer.config)
                r=$(mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "SHOW SLAVE STATUS\G;" | grep 'Master_Host\|Slave_IO_Running')
                if grep -q "Slave_IO_Running" <<< "$r"; then
                    echo "True"
                    exit 0
                fi
            else
                echo "False"
                exit 0
            fi
        fi
    fi
fi




