#!/usr/bin/env bash


param1="$1"
param2="$2"
param3="$3"
param4="$4"
param5="$5"

#param1="root"
#param2="aCOAkk4di4n!"
#param3="00-50-56-A4-D0-82"
#param4="3.0"
#param5="https://ls1.licycle.net/api/v1/logs/system"

if [ -z "$param1" ]
then
	echo "ERROR Missing Mysql User parameter"	
	exit 1
fi

if [ -z "$param2" ]
then
	echo "ERROR Missing Mysql Pwd parameter"	
	exit 1
fi

if [ -z "$param3" ]
then
	echo "ERROR Missing HWD parameter"	
	exit 1
fi

if [ -z "$param4" ]
then
	echo "ERROR Missing Version parameter"	
	exit 1
fi

if [ -z "$param5" ]
then
	echo "ERROR Missing Url Destination parameter"	
	exit 1
fi


currenttimestamp=$(date +%s)
read lasttimestamp < /home/akkadianuser/scripts/JSON_TIME.txt
read laststatusjson < /home/akkadianuser/scripts/JSON_STATUS.txt


DISK_TOTAL="failed"
DISK_USAGE="failed"
CPU_USAGE="failed"
MEM_TOTAL="failed"
MEM_USAGE="failed"


if [ -z "$lasttimestamp" ]
then	
	lasttimestamp=$currenttimestamp
fi
timespend=$((currenttimestamp-lasttimestamp))	



if [ $timespend == 0 ] || [ $timespend -gt 5 ] || [ -z "$laststatusjson" ]
then

# CPU AND MEM STATUS
# CPU_USAGE=$(top -b -n1 | grep -E '^(%Cpu)' | awk 'FNR == 1 {print "" 100-$8 "%"}')
# CPU_USAGE=$(iostat -c | grep -A 2 -E 'avg-cpu:' | awk 'FNR==2 {print $1}')
CPU_USAGE=$(top -bn1 | grep "Cpu(s)" | sed -e 's/^%Cpu.*ni,\(.*\)id.*st$/\1/' | awk '{print 100-$1}')

MEM_=$(free -m | grep 'Mem' |  awk '{print $2":"$3}')

# DISK STATUS
DISK=$(df -H / | grep /dev | awk '{print $2":"$3 }')

# KESTREL STATUS
KESTREL=$(systemctl status aco-server.service --lines=0 | grep 'Active:' | awk '{print "" $2}')

# TOMCAT STATUS
TOMCAT=$(systemctl status tomcat.service --lines=0 | grep -E '^( {0,3}Active)' | awk '{print "" $2}' )

# MONGO STATUS
MONGO=$(systemctl status mongodb.service --lines=0| grep 'Active:' |  awk '{print "" $2}')

# MYSQL STATUS
MYSQL=$(systemctl status mysqld.service --lines=0 | grep 'Active:' |  awk '{print "" $2}')

# JTAPI VERSION
JTAPI=$(unzip -q -c /opt/tomcat/lib/jtapi-9.1.jar META-INF/MANIFEST.MF | grep Implementation-Version: | awk '{print "" $2}')


# ENTRIES COUNT
ENTRIES=$(MYSQL_PWD=$param2 mysql -u $param1 -e "select count(*) total from (SELECT CONCAT(firstName,' ',lastName) as name, telephoneNumber_view as line FROM fp.DirectoryEntry  where type ='AXL') x;" | grep -A 2 total |  awk 'FNR == 2 {print "" $0 }')

# DEVICE COUNT
DEVICES=$(MYSQL_PWD=$param2 mysql -u $param1 -e "select count(*) total from ( SELECT distinct 0 as line, name, provider FROM fp.Device) x; " | grep -A 2 total |  awk 'FNR == 2 {print "" $0 }')


IFS=':' read -ra ADISK <<< "$DISK"
DISK_TOTAL="${ADISK[0]}"
DISK_USAGE="${ADISK[1]}"


IFS=':' read -ra ACPU_MEM <<< "$MEM_"
MEM_TOTAL="${ACPU_MEM[0]}MB"
MEM_USAGE="${ACPU_MEM[1]}MB"

JSON_DESTINATION="$param5"
JSON_STATUS="{\"ProducName\":\"TEST\",\"Hwd\":\"${param3}\",\"Version\":\"${param4}\",\"MySqlDBStatus\":\"${MYSQL}\",\"MongoStatus\":\"${MONGO}\",\"MemTotal\":\"${MEM_TOTAL}\",\"MemUsed\":\"${MEM_USAGE}\",\"DiskTotal\":\"${DISK_TOTAL}\",\"DiskUsed\":\"${DISK_USAGE}\",\"CPUUsages\":\"${CPU_USAGE}\",\"CUCMStatus\":\"No Validated\",\"AXLStatus\":\"No Validated\",\"JTAPIStatus\":\"${JTAPI}\",\"TotalDevice\":\"${DEVICES}\",\"DirectorySize\":\"${ENTRIES}\",\"TomcatStatus\":\"${TOMCAT}\",\"KestrelStatus\":\"${KESTREL}\",\"AppacheStatus\":\"none\",\"HAStatus\":\"none\"}"


echo $JSON_STATUS > /home/akkadianuser/scripts/JSON_STATUS.txt
echo $currenttimestamp > /home/akkadianuser/scripts/JSON_TIME.txt

else
 JSON_DESTINATION="$param5"
 JSON_STATUS="$laststatusjson"

fi

echo $JSON_STATUS


