#!/usr/bin/env bash

#returns the highest version or nothing if both parameters are equal

#param is read into an array as tokens separated by dot
read -a VERSION_A_NUMBERS <<< ${1//./$' '}
read -a VERSION_B_NUMBERS <<< ${2//./$' '}

let VERSION_A_NUMBERS_LENGTH=${#VERSION_A_NUMBERS[*]}
let VERSION_B_NUMBERS_LENGTH=${#VERSION_B_NUMBERS[*]}

if [[ $VERSION_A_NUMBERS_LENGTH -gt $VERSION_B_NUMBERS_LENGTH ]]
then
    let MAX_VERSION_INDEX=$VERSION_A_NUMBERS_LENGTH-1
else
    let MAX_VERSION_INDEX=$VERSION_B_NUMBERS_LENGTH-1
fi

#Find highest version
for ((i = 0; i <= MAX_VERSION_INDEX; ++i))
do
    #Get value, convert to number using let, default to 0 if index undefined
    let NUMBER_A=${VERSION_A_NUMBERS[$i]}
    let NUMBER_B=${VERSION_B_NUMBERS[$i]}

    if [[ $NUMBER_B -gt $NUMBER_A ]]
    then
      echo $2
      exit
    fi

    if [[ $NUMBER_B -lt $NUMBER_A ]]
    then
      echo $1
      exit
    fi
done