#!/usr/bin/env bash
# Backup user

if id "haakkadianuser" >/dev/null 2>&1; then
    echo "user already exists, nothing to do"
else
    echo $'\n' "Creating ha akkadian user..."
    sudo adduser haakkadianuser
    echo "haakkadianpassword" | passwd --stdin haakkadianuser
    sudo usermod -a -G haclient haakkadianuser

    sudo echo $'\n' "# HA Akkadian user configuration" >> /etc/sudoers
    sudo echo "haakkadianuser ALL=(ALL) ALL" >> /etc/sudoers
    sudo echo "%haakkadianuser   ALL=(ALL) NOPASSWD: ALL" >> /etc/sudoers

    sudo pcs property set enable-acl=true --force

    sudo pcs acl role create write-access description="Full access" write xpath /cib
    sudo pcs acl role create read-only description="Read access to cluster" read xpath /cib
    sudo pcs acl user create haakkadianuser write-access
    sudo pcs acl user create haakkadianuser read-only
fi