#!/usr/bin/env bash
current_release_zip_name=$1
if [[ (${current_release_zip_name} == "http"*) || (${current_release_zip_name} == "ftp"*) ]]; then
    # get the update file as /tmp/acm_release.zip
    wget ${current_release_zip_name} -O /tmp/acm_release.zip
else
    sudo cp -Rf ${current_release_zip_name} /tmp/acm_release.zip
fi

# unzip into /tmp/acm_release dir
unzip /tmp/acm_release.zip -d /tmp/acm_release

# get the release version from the file path
ACM_RELEASE_VERSION=$(basename $(find /tmp/acm_release -type f -print -quit) .bundle)

# cd into web directory
cd /var/www/html/acm/

# update codebase
git tag -d ${ACM_RELEASE_VERSION}

git bundle verify /tmp/acm_release/${ACM_RELEASE_VERSION}.bundle

git fetch /tmp/acm_release/${ACM_RELEASE_VERSION}.bundle ${ACM_RELEASE_VERSION}:localRef

git checkout ${ACM_RELEASE_VERSION} --force

# run migrations
if [ ! -d /var/lib/database ]; then
    mkdir /var/lib/database
fi
mv -f /var/www/html/acm/db/phinx.yml /var/lib/database

vendor/bin/phinx migrate -c /var/lib/database/phinx.yml

# remove all update files
rm -rf /tmp/acm_release*

# update a flag
touch /var/www/html/acm/application_updated.txt
