#!/usr/bin/env bash

# CLI (auto update) updater script
#
# parameter:
#           * path where to save the backup
#           * url where to get the file tui.tar.gz

# Set default version to 0.0.0.0 in case we're updating from an old cli version that does not have the get_cli_version
# script.
version_before="0.0.0.0"
# Check if cli version check script exists.
if [[ -f /home/akkadianuser/scripts/get_cli_version.sh ]]; then
  version_before=$(sh /home/akkadianuser/scripts/get_cli_version.sh | awk -F '-' '{print $1}')
fi

if [[ ! -d /home/akkadianuser/tmp ]]; then
    mkdir /home/akkadianuser/tmp
fi

if [[ ! -d /home/akkadianuser/tmp/akkappmanager_installation ]]; then
    mkdir /home/akkadianuser/tmp/akkappmanager_installation    
fi

sudo chmod -R 777 /home/akkadianuser/tmp/akkappmanager_installation

current_tmp_release_folder=/home/akkadianuser/tmp/akkappmanager_installation
current_release_zip_name=`echo $1 | sed -r "s/\x1B\[([0-9]{1,3}((;[0-9]{1,3})*)?)?[m|K]//g"`;
current_app_folder=/home/akkadianuser
backup_directory=/home/backups/akkappmanager/
backup_release_directory=${backup_directory}

current_app_folder=/home/akkadianuser

if [[ $current_release_zip_name == "cli_updates" ]]; then
    current_release_zip_name=$(sudo ls -1 /var/www/cli_updates/AAM_TUI*.tar.gz 2>/dev/null | tail -1)
fi

if [ ! -e ${backup_directory} ]
then
    mkdir ${backup_directory}
fi

if [ ! -e ${backup_release_directory} ]
then
    mkdir ${backup_release_directory}
fi

if [ -e ${current_tmp_release_folder} ]
then
    rm -Rf ${current_tmp_release_folder}
fi

if [ ! -e ${current_tmp_release_folder} ]
then
    mkdir ${current_tmp_release_folder}
fi

echo "Starting the installation of Akkadian Appliance Manager" > /home/akkadianuser/logs/cli_installation.log
date >> /home/akkadianuser/logs/cli_installation.log


# Do we need to download the file?
if [[ ( ${current_release_zip_name} == "http"* ) || ( ${current_release_zip_name} == "ftp"* ) ]]
then
    echo 'Getting update file' >> /home/akkadianuser/logs/cli_installation.log
    sudo wget ${current_release_zip_name} -P ${current_tmp_release_folder}/
else
    echo "copying ${current_release_zip_name} file into ${current_tmp_release_folder}" >> /home/akkadianuser/logs/cli_installation.log
    sudo cp -Rf ${current_release_zip_name} ${current_tmp_release_folder}
fi

echo 'Authenticating and unzipping update file' >> /home/akkadianuser/logs/cli_installation.log

sudo tar -xvzf ${current_tmp_release_folder}/$(basename ${current_release_zip_name}) -C ${current_tmp_release_folder}/
#sudo openssl enc -d -aes-256-cbc -in ${current_tmp_release_folder}/$(basename ${current_release_zip_name}) -pass pass:'HtBr6QckqJPk4rpatyUNT594' | tar xz -C ${current_tmp_release_folder}/

if [[ $? -eq 0 ]]; then

    echo 'copying needed files...' >> /home/akkadianuser/logs/cli_installation.log

    echo ${current_app_folder}
    sudo cp -Rf ${current_app_folder}/sync_start_at_log ${current_app_folder}/sync_end_at_log ${current_tmp_release_folder}
    sudo cp -Rf ${current_tmp_release_folder}/* ${current_tmp_release_folder}/.* ${current_app_folder} &
    BACK_PID=$!

    #TODO:wait until the current_app_folder is modified
    while kill -0 $BACK_PID ; do
        echo "Process is still active..." >> /home/akkadianuser/logs/cli_installation.log
        sleep 1
        # You can add a timeout here if you want
    done

    echo 'changing permissions...' >> /home/akkadianuser/logs/cli_installation.log
    dos2unix /home/akkadianuser/*
    sudo chown -R akkadianuser:akkadianuser /home/akkadianuser
    sudo chmod +x /home/akkadianuser/scripts/*


    sudo rm -Rf venv/
    sudo rm -Rf netifaces-0.10.4/
    sudo rm -Rf build/
    sudo rm -Rf dist/
    sudo rm -Rf tui.tar.gz
    sudo rm -Rf tui/
    sudo rm -Rf akkadianAppManager.egg-info/
    sudo rm -Rf /usr/lib/python2.7/site-packages/akkadianAppManager-1.0-py2.7.egg

    sleep 5

    echo "Modifying folder permissions" >> /home/akkadianuser/logs/cli_installation.log
    if [[  ! -d /var/www ]]; then
        sudo mkdir /var/www
        sudo chown -R apache:root /var/www
        sudo chmod -R 755 /var/www
    fi

    if [[  ! -d /var/www/product_update ]]; then
        sudo mkdir /var/www/product_update
        sudo chown -R apache:root /var/www/product_update
        sudo chmod -R 755 /var/www/product_update
    fi

    if [[ ! -d /var/www/html/ha ]]; then
        sudo mkdir /var/www/html/ha
        sudo chown -R apache:root /var/www/html/ha
        sudo chmod -R 755 /var/www/html/ha
    fi


    if [[ ! -d /var/www/cli_updates ]]; then
        sudo mkdir /var/www/cli_updates
        sudo chown -R apache:root /var/www/cli_updates
        sudo chmod -R 755 /var/www/cli_updates
    fi

    if [[ -d /opt/akkadian/aco-server ]]; then
        echo 'aCO requires noode, gcc and c++ installing them...' >> /home/akkadianuser/logs/cli_installation.log
        isNodeInstalled=$(node -v)
        isSNMPInstalled=$(systemctl status snmpd)

        if [[ "$isNodeInstalled" == "" ]]; then
            #If it is aco, then install nodejs
            sudo yum -y install -y gcc-c++ make
            sudo curl -sL https://rpm.nodesource.com/setup_6.x | sudo -E bash -
            sudo yum -y install nodejs
        fi

        if grep -q "Active: active (running)" <<< "$isSNMPInstalled"; then
            echo "Nothing to do, snmpd is already installed"
        else
            sudo yum -y install net-snmp net-snmp-utils
            sudo systemctl enable snmpd
            sudo systemctl start snmpd
        fi
    fi

    echo 'Copying update_main file to get access from auu...' >> /home/akkadianuser/logs/cli_installation.log
    sudo cp -Rf /home/akkadianuser/scripts/universal_updater/update_main.sh /var/www/product_update/
    sudo rm -Rf /var/www/cli_updates/*

    sudo rm -Rf /home/akkadianuser/tui*.tar.gz
    sudo rm -Rf /home/akkadianuser/AAM_TUI*.tar.gz


    #TODO migrate this to git, I'm doing it here to reduce the risk and because if cli comes from the begining of the times
    #in which we deploy manually
    rm -Rf /home/akkadianuser/akkadianAppManager.egg-info
    rm -Rf /home/akkadianuser/netifaces-0.10.4

    rm -Rf /home/akkadianuser/.sshpass_*

    cd /home/akkadianuser
    sudo rm -Rf /bin/akkadianAppManager
    sudo python3 setup.py install

    version_after=""
    # Check if cli version check script exists.
    if [[ -f /home/akkadianuser/scripts/get_cli_version.sh ]]; then
        version_after=$(sh /home/akkadianuser/scripts/get_cli_version.sh | awk -F '-' '{print $1}')
    fi

    # Write to the install history if we have a version before and version after that are different.
    if [[ $version_after != "" && $version_before != "" ]]; then
        d=$(date)

        echo "cli,$d,$version_before,$version_after" >>/var/www/product_update/installation_history.csv
    fi

    echo 'Restarting executor...' >> /home/akkadianuser/logs/cli_installation.log
    sudo echo "yes" > /home/akkadianuser/global_variables/restart_executor

    if [[ -d /opt/akkadian/aco-server/ ]]; then
        sleep 3
        sh /home/akkadianuser/universal_installer_scripts/pre-scripts/pre-script_main.sh > /home/akkadianuser/logs/aco_installation.log
        sleep 3
        sh /home/akkadianuser/universal_installer_scripts/post-scripts/post-script_main.sh >> /home/akkadianuser/logs/aco_installation.log
    fi

else
    echo ""
    echo "ERROR - Failed to authenticate CLI Update file, please verify and try again." >> /home/akkadianuser/logs/cli_installation.log
    exit 1
fi
