#!/usr/bin/env bash

LRED='\033[1;31m'
LBLUE='\033[1;34m'
LGREEN='\033[1;32m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color

if [[ ! -d /home/akkadianuser/logs/ ]]; then
    sudo mkdir /home/akkadianuser/logs
fi

if [[ ! -f /home/akkadianuser/logs/asb_1x_update_fix.log ]]; then
    echo "Starting file" > /home/akkadianuser/logs/asb_1x_update_fix.log
fi

date >> /home/akkadianuser/logs/asb_1x_update_fix.log

#No params so show help message
if [[ $# -eq 0 ]]
then
    echo -e "${YELLOW}Usage: $0 /path/to/asb${NC}" >> /home/akkadianuser/logs/asb_1x_update_fix.log
    exit 0
fi

#Remove trailing slash from directory
APP_DIRECTORY=${1%/}
APP_GIT_CMD="git --work-tree=$APP_DIRECTORY --git-dir=$APP_DIRECTORY/.git"

#Verify we are working on an ASB directory
if [[ -z $(grep 'APP_NAME\s*=\s*["'']Site Builder["'']' $APP_DIRECTORY/.env) ]]
then
    echo -e "${LRED}Invalid ASB directory. Please check the path '$APP_DIRECTORY' ${NC}" >> /home/akkadianuser/logs/asb_1x_update_fix.log
    exit 0
fi


#Get current local version
INSTALLED_RELEASE_VERSION_FULL_TAG=$($APP_GIT_CMD describe --tags --exact-match)

#Remove asb fetch command from cron.
#Line looks like this:     @daily git --work-tree=/var/www/html/asb/ --git-dir=/var/www/html/asb/.git fetch --all
#But casting a wider net in grep below incase there are minor differences between HCS and ASB standalone
echo -e "${LBLUE}Removing daily fetch...${NC}" >> /home/akkadianuser/logs/asb_1x_update_fix.log
crontab -u root -l | grep -v 'asb/.git fetch --all'  | crontab -u root -

#Remove origin to prevent someone from manually doing a fetch and messing things up
echo -e "${LBLUE}Removing remote origin...${NC}" >> /home/akkadianuser/logs/asb_1x_update_fix.log
$APP_GIT_CMD remote rm origin

#Checkout code again in case some files were not checked out in a previous bad upgrade or someone manually
#modified a file without restoring it during debug/testing
echo -e "${LBLUE}Cleaning installed files...${NC}" >> /home/akkadianuser/logs/asb_1x_update_fix.log
$APP_GIT_CMD checkout -f

#Delete all tags except current tag
echo -e "${LBLUE}Removing tags...${NC}" >> /home/akkadianuser/logs/asb_1x_update_fix.log
$APP_GIT_CMD tag -d $($APP_GIT_CMD tag -l | grep -v "^$INSTALLED_RELEASE_VERSION_FULL_TAG\$")

#Clear cache
echo -e "${LBLUE}Clearing Cache...${NC}" >> /home/akkadianuser/logs/asb_1x_update_fix.log
rm -f $APP_DIRECTORY/bootstrap/cache/*.php
php $APP_DIRECTORY/artisan cache:clear
php $APP_DIRECTORY/artisan view:clear
php $APP_DIRECTORY/artisan config:clear
php $APP_DIRECTORY/artisan route:clear

#Update permissions so migrations don't fail
echo -e "${LBLUE}Updating Permissions...${NC}" >> /home/akkadianuser/logs/asb_1x_update_fix.log
chown -R root:apache $APP_DIRECTORY
chmod -R 2775 $APP_DIRECTORY
chmod -R 2777 $APP_DIRECTORY/storage

#Run migrations
echo -e "${LBLUE}Running migrations...${NC}" >> /home/akkadianuser/logs/asb_1x_update_fix.log
php $APP_DIRECTORY/artisan migrate --force

#Restart queue
echo -e "${LBLUE}Restarting queue...${NC}" >> /home/akkadianuser/logs/asb_1x_update_fix.log
php $APP_DIRECTORY/artisan queue:restart

#Make sure we don't count permission differences as a change in git
echo -e "${LBLUE}Updating file mode...${NC}" >> /home/akkadianuser/logs/asb_1x_update_fix.log
$APP_GIT_CMD config core.fileMode false

#Update permissions again in case migrations or
#queue restart commands modified/created files as current logged in user
echo -e "${LBLUE}Finalizing Permissions...${NC}" >> /home/akkadianuser/logs/asb_1x_update_fix.log
chown -R root:apache $APP_DIRECTORY
chmod -R 2775 $APP_DIRECTORY
chmod -R 2777 $APP_DIRECTORY/storage

echo -e "${LGREEN}Done.${NC}" >> /home/akkadianuser/logs/asb_1x_update_fix.log

sudo mkdir /home/akkadianuser/scripts/executed_fixes/
sudo echo "done" > /home/akkadianuser/scripts/executed_fixes/asb_1x_update_fix.done