#!/usr/bin/env bash

echo "####### starting the restore of db ########## " >> /home/akkadianuser/restoring.log
date >> /home/akkadianuser/restoring.log

echo "Disabling replica" >> /home/akkadianuser/restoring.log
MASTER=$(sudo pcs status | grep RS_VIP_Akkadian | awk -F ' ' '{print $4}')
NODES=$(sudo pcs status | grep Online: | awk -F : '{print $2}')
hostname=$(sudo hostname)

ran=$(( ( RANDOM % 100 )  + 1 ))
gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_aco.gpg > /home/akkadianuser/.sshpass_$ran

echo "Making nodes standalone" >> /home/akkadianuser/restoring.log
IFS=$' '
for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]
        then
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "systemctl stop crond"
            echo "Removing replica configs in $j" >> /home/akkadianuser/restoring.log
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "systemctl stop mongodb"
            sleep 3
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "cp -Rf /home/akkadianuser/scripts/mongo_replica_scripts/start-mongo.sh /opt/akkadian/aco-server/scripts/start-mongodb.sh"
            echo "starting mongo without replication" >> /home/akkadianuser/restoring.log
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "systemctl start mongodb"
            sleep 3
        fi
done

echo "Restoring DB locally, once replica is up again this will replicate" >> /home/akkadianuser/restoring.log
cd "/usr/bin/"
mongo -u mongoDBuser -p X46kTVmongo --authenticationDatabase admin AcoServer --eval "db.dropDatabase()"
mongo -u mongoDBuser -p X46kTVmongo --authenticationDatabase admin AcoServer --eval "db.createCollection('AcoServer')"
mongorestore -u mongoDBuser -p X46kTVmongo --authenticationDatabase admin --db AcoServer /opt/akkadian/data/restore/AcoServer

echo "Restoring DB remotelly" >> /home/akkadianuser/restoring.log

sudo tar -zcvf /opt/akkadian/data/restore/acoServer_base.tar.gz -C /opt/akkadian/data/restore/AcoServer/ .
nodes_len=0
initialization_string=""
IFS=$' '
for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]
        then
            nodes_len=$(($nodes_len+1))
            echo "processing start configs for: $j" >> /home/akkadianuser/restoring.log

            #Ensuring slaves have always same data
            if [[ "$j" != "$hostname" ]]
            then
                sshpass -f /home/akkadianuser/.sshpass_$ran scp -o StrictHostKeyChecking=no /opt/akkadian/data/restore/acoServer_base.tar.gz root@$j:/opt/akkadian/data/restore/acoServer_base.tar.gz
                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo rm -Rf /opt/akkadian/data/restore/AcoServer"
                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo mkdir /opt/akkadian/data/restore/AcoServer"
                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "tar -zxvf /opt/akkadian/data/restore/acoServer_base.tar.gz -C /opt/akkadian/data/restore/AcoServer"
                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sh /opt/akkadian/aco-server/scripts/mongoacorestore.sh"
            fi
            sleep 5

            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo cp -Rf /home/akkadianuser/scripts/mongo_replica_scripts/start-mongo-replica.sh /opt/akkadian/aco-server/scripts/start-mongodb.sh"
            sleep 3
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo systemctl restart mongodb"
            sleep 3
        fi
done


echo "Waiting mongo starts..."  >> /home/akkadianuser/restoring.log
sleep 5

echo "starting crond again" >> /home/akkadianuser/restoring.log
sudo systemctl start crond

echo "nodes: $NODES" >> /home/akkadianuser/restoring.log

IFS=$' '
for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) && ( "$hostname" != "$j" ) ]]
        then
            echo "Trying to start $j cron job" >> /home/akkadianuser/restoring.log
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo systemctl start crond"
        fi
done

sudo rm -Rf /home/akkadianuser/.sshpass_$ran

echo "####### ending the restore of db ########## " >> /home/akkadianuser/restoring.log

sudo systemctl restart aco-server