#!/usr/bin/env bash


#EXAMPLE: sh /home/akkadianuser/scripts/aco_utils/backup_db_in_ha.sh /opt/akkadian/data/backups  /opt/akkadian/data/backups/test.zip

echo "####### starting the backup process of db ########## " >> /home/akkadianuser/restoring.log
date >> /home/akkadianuser/backing.log

echo "Disabling replica" >> /home/akkadianuser/backing.log
MASTER=$(sudo pcs status | grep RS_VIP_Akkadian | awk -F ' ' '{print $4}')
NODES=$(sudo pcs status | grep Online: | awk -F : '{print $2}')
hostname=$(sudo hostname)

if [[ ($NODES == *"Error: cluster is not currently running on this node"*) || ($NODES == "") ]]; then
    echo "LOAD BALANCER MODE: ${NODES}" >> /home/akkadianuser/backing.log
    NODES=$(/home/akkadianuser/scripts/ha/get_node_list.sh)
else
    echo "FULL HA MODE: ${NODES}" >> /home/akkadianuser/backing.log
fi


ran=$(( ( RANDOM % 100 )  + 1 ))
gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_aco.gpg > /home/akkadianuser/.sshpass_$ran

echo "Making nodes standalone" >> /home/akkadianuser/backing.log
IFS=$' '
for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]
        then
	    echo "PROCESSING: $j" >> /home/akkadianuser/backing.log
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "systemctl stop crond"
            echo "Removing replica configs in $j" >> /home/akkadianuser/backing.log
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "systemctl stop mongodb"
            sleep 3
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "cp -Rf /home/akkadianuser/scripts/mongo_replica_scripts/start-mongo.sh /opt/akkadian/aco-server/scripts/start-mongodb.sh"
            echo "starting mongo without replication" >> /home/akkadianuser/backing.log
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "systemctl start mongodb"
            sleep 3
        fi
done

sleep 5

echo "Dumping DB locally" >> /home/akkadianuser/backing.log
echo "/usr/bin/mongodump  -u mongoDBuser -p X46kTVmongo --authenticationDatabase admin --db AcoServer -o $1" >> /home/akkadianuser/backing.log

sudo rm -Rf /opt/akkadian/data/backups/AcoServer
re=$(sudo rm -Rf $2 AcoServer);


#/usr/bin/mongodump  -u mongoDBuser -p X46kTVmongo --authenticationDatabase admin --db AcoServer -o "$1"
result=$(/usr/bin/mongodump  -u mongoDBuser -p X46kTVmongo --authenticationDatabase admin --db AcoServer -o "$1");


if [[ $result == *"Failed:"* ]] || [[ $result == *"error:"* ]] ; then

	echo "Error: Dumping DB Failed" >> /home/akkadianuser/backing.log
	exit 1

else

	echo "Dumping DB Successful" >> /home/akkadianuser/backing.log

	IFS=$' '
	for j in $NODES
	    do
		if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]
		then
		    nodes_len=$(($nodes_len+1))
		    echo "processing start configs for: $j" >> /home/akkadianuser/backing.log

		    sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo cp -Rf /home/akkadianuser/scripts/mongo_replica_scripts/start-mongo-replica.sh /opt/akkadian/aco-server/scripts/start-mongodb.sh"
		    sleep 3
		    sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo systemctl restart mongodb"
		    sleep 3
		fi
	done

	echo "starting crond again" >> /home/akkadianuser/backing.log


	#sudo systemctl start crond
	result=$(sudo systemctl start crond);
	result=$(sudo systemctl status crond);


	if [[ $result == *"Loaded: loaded"* ]] && [[ $result == *"Active: active"* ]]; then

		echo "Crond started" >> /home/akkadianuser/backing.log

		echo "nodes: $NODES" >> /home/akkadianuser/backing.log

		IFS=$' '
		for j in $NODES
		    do
			if [[ ( "$j" != "[" ) && ( "$j" != "]" ) && ( "$hostname" != "$j" ) ]]
			then
			    echo "Trying to start $j cron job" >> /home/akkadianuser/backing.log
			    sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo systemctl start crond"
			fi
		done

		sudo rm -Rf /home/akkadianuser/.sshpass_$ran

		file=$2
		echo "taking backup in ${file%.zip}" >> /home/akkadianuser/backing.log

		if [[ $3 == "yes" ]]; then
		    cd ${file%.zip}
		else
		    cd /opt/akkadian/data/backups
		fi

		echo "sudo zip -r $2 AcoServer" >> /home/akkadianuser/backing.log
		result=$(sudo zip -r $2 AcoServer);
		
		sleep 1

		if [[ ($result == *"updating: AcoServer"*) || ($result == *"adding: AcoServer"*) ]]; then
			cd /home/akkadianuser
			echo "Backup in zip done" >> /home/akkadianuser/backing.log		
		else
			echo "Error: Can't ZIP: $result " >> /home/akkadianuser/backing.log
			exit 1
		fi
	else

		echo "Error: Crond doesn't start" >> /home/akkadianuser/backing.log
		exit 1
	fi
fi

exit 0




