#!/usr/bin/env bash

# ACO SERVER and ACO WEB updater script
#
# parameter:
#           * url where to get the file aco.tar.gz with acoserver.tar.gz and acow-webapp.war inside
#           * md5 code current_tmp_release_folder
#

updater_file="aco.tar.gz"
updater_encrypted_file="aco.tar.gz.gpg"
server_updater_file="acoserver.tar.gz"
web_updater_file="acow-webapp.war"

current_tmp_release_folder=/opt/akkadian/data/tmp
current_app_folder=/home/akkadianuser
current_server_folder=/opt/akkadian/aco-server
current_web_folder=/opt/tomcat/webapps
current_tomcat_base_folder=/opt/tomcat

path_script=/home/akkadianuser/scripts
path_logs=/home/akkadianuser/logs

current_release_zip_name=`echo $1 | sed -r "s/\x1B\[([0-9]{1,3}((;[0-9]{1,3})*)?)?[m|K]//g"`;
jtapi_version=`echo $2`;

# Flags variables
server_flag=0
web_flag=0
word1formd5=""
word2formd5=""

isEncrypted=0;
isDownloaded=0;

if [[ ( ${current_release_zip_name} == *".gpg" ) ]];
then
    isEncrypted=1;
fi

v=$(date)

info="${info} Starting the installation of Akkadian CO"
info="${info}\n ${v}" 
info="${info}\n Jtapi Version: $jtapi_version" >> ${path_logs}/aco_installation.log
info="${info}\n File is encrypted: $isEncrypted"


if [[ -e ${current_tmp_release_folder}/${updater_file} ]]; then
	info="${info}\n INFO: Deleting ${current_tmp_release_folder}/${updater_file} !"
	sudo rm -Rf ${current_tmp_release_folder}/${updater_file};
fi

if [[ -e ${current_tmp_release_folder}/${updater_encrypted_file} ]]; then
	info="${info}\n INFO: Deleting ${current_tmp_release_folder}/${updater_encrypted_file} !"
	sudo rm -Rf ${current_tmp_release_folder}/${updater_encrypted_file};
fi

if [[ -e ${current_tmp_release_folder}/aco_server_web.md5 ]]; then
	info="${info}\n INFO: Deleting ${current_tmp_release_folder}/aco_server_web.md5 !"
	sudo rm -Rf ${current_tmp_release_folder}/aco_server_web.md5;
fi


# --------------------- first process to validate md5 checksum --------------------
url="$1"
originalfilename=$(echo "$url" | awk -F"/" '{print $NF}')
newfilename=""

filemd5name=$(echo ${url%/*})
filemd5name="$filemd5name/aco_server_web.md5"

if [[ ( ${current_release_zip_name} == "http"* ) || ( ${current_release_zip_name} == "ftp"* ) ]]
then
    result=$(wget $filemd5name -O ${current_tmp_release_folder}/aco_server_web.md5)
    word1formd5="download"
    word2formd5="remote server"
else
#   result=$(cp -Rf $filemd5name ${current_tmp_release_folder}/aco_server_web.md5)
    word1formd5="copy"
    word2formd5="local path"
fi

existmd5="false"
ischecksumok="false"

if [[ ! -e ${current_tmp_release_folder}/aco_server_web.md5 ]]; then	
  info="${info}\n WARNING: Couldn't ${word1formd5} aco_server_web.md5"
	existmd5="false";
else
	existmd5="true";
fi
# -----------------------------------------------------------------------------------




if [[ ( ${current_release_zip_name} == "http"* ) || ( ${current_release_zip_name} == "ftp"* ) ]]
then
    #from CLI
    
    if [[ ( ${isEncrypted} == 1 ) ]]
    then
	    wget $1 -O ${current_tmp_release_folder}/${updater_encrypted_file}
	    if [[ ! -e ${current_tmp_release_folder}/${updater_encrypted_file} ]]; then
		    info="${info}\n ERROR: Couldn't download updater gpg file!"
      else
		    isDownloaded=1;
        newfilename="${updater_encrypted_file}"
	    fi
    else 
	    wget $1 -O ${current_tmp_release_folder}/${updater_file}
	    if [[ ! -e ${current_tmp_release_folder}/${updater_file} ]]; then
                info="${info}\n ERROR: Couldn't download updater file!"
            else
                isDownloaded=1;
                newfilename="${updater_file}"	
	    fi
    fi
else
    #from portal
    echo "This is local"
    if [[ ( ${isEncrypted} == 1 ) ]]
    then
	    sudo cp -Rf ${current_release_zip_name} ${current_tmp_release_folder}/${updater_encrypted_file}
	    if [[ ! -e ${current_tmp_release_folder}/${updater_encrypted_file} ]]; then
		    info="${info}\n ERROR: Couldn't copy encrypted media file!"
      else
        isDownloaded=1;
        newfilename="${updater_encrypted_file}"
	    fi

    else
	    sudo cp -Rf ${current_release_zip_name} ${current_tmp_release_folder}/${updater_file}
	    if [[ ! -e ${current_tmp_release_folder}/${updater_file} ]]; then
        info="${info}\n ERROR: Couldn't copy media file!"
      else
        isDownloaded=1;
        newfilename="${updater_file}"
	    fi
    fi
fi



# --------------------- second process to validate md5 checksum --------------------

if [[ ( $existmd5 == "true" ) ]]; then
	#echo "originalfilename: $originalfilename"
        #echo "newfilename: $newfilename"

        # downloaded file name was changed. So the name in md5 must be changed
        sed -i "s/$originalfilename/$newfilename/" ${current_tmp_release_folder}/aco_server_web.md5
        info="${info}\n INFO: md5 file exists on ${word2formd5}"

	if [[ ( ${isDownloaded} == 1 ) ]]; then

	    cd ${current_tmp_release_folder}
	    result=$(md5sum -c aco_server_web.md5)

	    if [[ $result == *"OK"* ]]; then
		    ischecksumok="true"
        info="${info}\n INFO: checksum md5 build is OK"
      else
        info="${info}\n ERROR: checksum md5 build is FAILED"
	    fi
	fi
else
    info="${info}\n WARNING: md5 file doesn't exist on ${word2formd5}"
fi
# -----------------------------------------------------------------------------------




echo -e "GRAL INFO:\n----------------------------------------\n${info}\n----------------------------------------" > ${path_logs}/aco_installation.log


if [[ ${isDownloaded} == 0 ]] || [[ ( "$existmd5" == "true" ) && ( "${ischecksumok}" == "false" ) ]]
then
    exit
fi



if [[ ( ${isEncrypted} == 1 ) ]]
then

	res=$(sh ${path_script}/aco_installation/aco_decrypt_tar.sh 2>&1)
	exitcode=$?

	echo -e "DECRYPT GPG:\n----------------------------------------\n${res}\n----------------------------------------" >> ${path_logs}/aco_installation.log

        if [ "${exitcode}" -ne 0 ]; then
		exit;
	fi
fi



# check=$(awk -F ': ' '{print $2}' <<< $(md5sum -c <<< "$2 ${current_tmp_release_folder}/${updater_file}"))
# if [ "$check" != "OK" ]; then
#    echo "ERROR: no properly formatted MD5 checksum lines found"; exit;
# fi


if [[ ( ${isDownloaded} == 1 ) ]]
then

	res=$(sh ${path_script}/aco_installation/aco_uncompress_tar.sh 2>&1)
	exitcode=$?

	echo -e "EXTRACT DOWNLOADED PACKAGE:\n----------------------------------------\n${res}\n----------------------------------------" >> ${path_logs}/aco_installation.log

        if [ "${exitcode}" -ne 0 ]; then
		exit;
	fi

	
	if [[ $res == *"@S@"* ]]; then
            server_flag=1;
        fi

	if [[ $res == *"@W@"* ]]; then
            web_flag=1;
        fi
fi

echo -e "PACKAGE CONTAINS:\n----------------------------------------\n ACO Server:${server_flag}\n ACO Web:${web_flag}\n----------------------------------------" >> ${path_logs}/aco_installation.log



if [[ "${server_flag}" -eq 1 ]]; then

  res=$(sh ${path_script}/aco_installation/aco_install_server.sh ${jtapi_version} 2>&1)
	exitcode=$?

	echo -e "UPDATING ACO SERVER:\n----------------------------------------\n${res}\n----------------------------------------" >> ${path_logs}/aco_installation.log

        if [ "${exitcode}" -ne 0 ]; then
		exit;
	fi
fi



if [[ "${web_flag}" -eq 1 ]]; then

	res=$(sh ${path_script}/aco_installation/aco_install_web.sh  2>&1)
	exitcode=$?

	echo -e "UPDATING ACO WEB:\n----------------------------------------\n${res}\n----------------------------------------" >> ${path_logs}/aco_installation.log

        if [ "${exitcode}" -ne 0 ]; then
		exit;
	fi
fi


if [[ ! -d /opt/akkadian/aco-server/external_certificates ]]; then
    sudo mkdir /opt/akkadian/aco-server/external_certificates
fi

echo -e "EXTRA :\n----------------------------------------\n" >> ${path_logs}/aco_installation.log

#install net 5 if needed
echo " Validation DOTNET UPGRADE..." >> ${path_logs}/aco_installation.log
sudo sh ${path_script}/upgrade_dotnet/upgradeDonet.sh

# upgrade nginx if needed
echo " Validation NGINX UPGRADE..." >> ${path_logs}/aco_installation.log
sudo sh ${path_script}/upgrade_nginx/upgradeNginx.sh


akkadian_cron_content=$(sudo crontab -u akkadianuser -l)
if [[ "$akkadian_cron_content" != *"remove_sch_backups.sh"* ]]; then
    akkadian="0 1 * * * sh /home/akkadianuser/scripts/aco_utils/remove_sch_backups.sh >> /home/akkadianuser/logs/aco_installation.log 2>&1"
    (sudo crontab -u akkadianuser -l; echo "$akkadian" ) | sudo crontab -u akkadianuser -
fi

if [[ "$akkadian_cron_content" != *"remove_logs.sh"* ]]; then
    akkadian="0 0 * * * sh /home/akkadianuser/scripts/aco_utils/remove_logs.sh >> /home/akkadianuser/logs/aco_installation.log 2>&1"
    (sudo crontab -u akkadianuser -l; echo "$akkadian" ) | sudo crontab -u akkadianuser -
fi


echo -e "\n----------------------------------------" >> ${path_logs}/aco_installation.log


echo -e "RESTART SERVICES:\n----------------------------------------\n" >> ${path_logs}/aco_installation.log

restartAcoServer=$(sudo systemctl restart aco-server) &
wait $!
codeAcoServer=$?

if [ ${codeAcoServer} -eq 0 ];
then
    echo " Restarted AcoServer" >> ${path_logs}/aco_installation.log
else
    echo " Failed to Restart AcoServer" >> ${path_logs}/aco_installation.log
fi

restartAcoWeb=$(sudo systemctl restart tomcat) &
wait $!
codeAcoWeb=$?

if [ ${codeAcoWeb} -eq 0 ];
then
    echo " Restarted tomcat" >> ${path_logs}/aco_installation.log
else
    echo " Failed to Restart Tomcat" >> ${path_logs}/aco_installation.log
fi

restarNginx=$(sudo systemctl restart nginx) &
wait $!
codeNginx=$?


if [ ${codeNginx} -eq 0 ];
then
    echo " Restarted nginx" >> ${path_logs}/aco_installation.log
else
    echo " Failed to Restart Nginx" >> ${path_logs}/aco_installation.log
fi

sleep 8

echo -e "\n----------------------------------------" >> ${path_logs}/aco_installation.log

re_install_web=0
if [[ "${web_flag}" -eq 1 ]]; then

	res=$(sh ${path_script}/aco_installation/aco_test_web.sh 2>&1)
	exitcode=$?

	echo -e "TEST ACO WEB:\n----------------------------------------\n${res}\n----------------------------------------" >> ${path_logs}/aco_installation.log

        if [ "${exitcode}" -ne 0 ]; then
	    if [[ "${res}" !=  *"TOMCAT INACTIVE"* ]] ; then
		re_install_web=1;
             fi
	fi
fi


if [[ "${re_install_web}" -eq 1 ]]; then

	res=$(sh ${path_script}/aco_installation/aco_install_web.sh 2>&1)
	exitcode=$?

	echo -e "REINSTALLING ACO WEB:\n----------------------------------------\n${res}\n----------------------------------------" >> ${path_logs}/aco_installation.log

        if [ "${exitcode}" -ne 0 ]; then
		exit;
	fi
fi

#TODO: we need to review this, since when the installation fails the folder keeps havinf garbage
echo -e "CLEAR :\n----------------------------------------" >> ${path_logs}/aco_installation.log

echo -e " Cleaning tempory files..." >> ${path_logs}/aco_installation.log
sudo rm -Rf ${current_tmp_release_folder}/*
echo -e  " DONE!" >> ${path_logs}/aco_installation.log

echo -e "\n----------------------------------------" >> ${path_logs}/aco_installation.log





