#!/usr/bin/env bash


current_tmp_release_folder=/opt/akkadian/data/tmp
updater_file="aco.tar.gz"
server_updater_file="acoserver.tar.gz"
web_updater_file="acow-webapp.war"

# Flags variables
server_flag="N"
web_flag="N"

code=0;
msg="";

res=$(tar -xvzf ${current_tmp_release_folder}/${updater_file} -C ${current_tmp_release_folder} 2>&1 ) &
wait $!
resultuncompress=$?


if [ "${resultuncompress}" -eq 0 ];
then
  	msg=" Extract Succesfull!"

	if [ ! -e ${current_tmp_release_folder}/${server_updater_file} ]; then
	    if [ ! -e ${current_tmp_release_folder}/${web_updater_file} ]; then
		msg="${msg}\n ERROR: The extracted files  don't contain AcoWeb and AcoServer updater. Please try again!"	
		code=1;
	    else
		msg="${msg}\n WARNING: The downloaded file don't contains the server updater. Only the ACO WEB will be update!"
		web_flag="@W@"
	    fi
	else
	    if [ ! -e ${current_tmp_release_folder}/${web_updater_file} ]; then
		msg="${msg}\n WARNING: The downloaded file don't contains the web updater. Only the ACO SERVER will be update!"
		server_flag="@S@"
	    else
		msg="${msg}\n INFO: The downloaded files contain AcoWeb and AcoServer updater"
		server_flag="@S@"
		web_flag="@W@"
	    fi
	fi
else 
  msg=" ERROR: Extract failed for file: ${current_tmp_release_folder}/${updater_file} : code ${resultuncompress} ${res}"
  code=1;
fi

echo " ${server_flag}${web_flag}" #DONT REMOVE THESE FLAGS.
echo "${msg}"
exit $code
