#!/usr/bin/env bash


current_web_folder=/opt/tomcat/webapps

ipaddress=$(hostname -I | awk '{print $1}')
statustomcat=$(sudo systemctl status tomcat.service | grep -e Active -e Loaded);
isTomcatActive="false"
isFolder="false"



if [[ "${statustomcat}" == *"Active: active"* ]] && [[ "${statustomcat}" == *"Loaded: loaded"* ]];
then
    isTomcatActive="true"
fi



if [ ${isTomcatActive} == "true" ]; then

	response=$(wget --server-response --no-check-certificate https://${ipaddress}/acow-webapp/ 2>&1)




	is_conected_nginx=$( echo "${response}" | grep 'Connecting' | sed -n 1p | grep -c 'connected') #for nginx
	is_conected_tomcat=$( echo "${response}" | grep 'Connecting' | sed -n 2p | grep -c 'connected') #for tomcat

	is_response_http_200=$( echo "${response}" | grep 'HTTP/1.1' | sed -n 1p | grep -c '200')
	is_response_http_301=$( echo "${response}" | grep 'HTTP/1.1' | sed -n 1p | grep -c '301')
	is_response_http_404=$( echo "${response}" | grep 'HTTP/1.1' | sed -n 1p | grep -c '404')
	is_response_http_502=$( echo "${response}" | grep 'HTTP/1.1' | sed -n 1p | grep -c '502')

	is_cant_verify_cert=$( echo "${response}" | grep -e 'ERROR: cannot verify' -e 'WARNING: cannot verify' | grep -c 'cannot verify' )

	status=""
	code=1


    #echo "$response"
	#echo "nginx: $is_conected_nginx"
	#echo "status 200: $is_response_http_200"
	#echo "status 301: $is_response_http_301"
	#echo "status 404: $is_response_http_404"
	#echo "status 502: $is_response_http_502"
	#echo "tomcat: $is_conected_tomcat"
	#echo "7 $is_cant_verify_cert"

	if [[ $is_response_http_200 -gt 0 ]] ;then
		status=" OK"
		code=0
	else
		if [[ $is_response_http_404 -gt 0 ]] ;then
	       status=" NOT FOUND"
		   code=1		   
        else
		   if [[ $is_response_http_502 -gt 0 ]] ;then
			   status=" BAD GATEWAY"
			   code=1
           else
               if [[ $is_response_http_301 -gt 0 ]] ;then
			       status=" REDIRECT"
			       code=1
               else
                   status=" UNDEFINED"
			       code=1
               fi
		   fi
		fi

	fi
    
    if [[ $is_cant_verify_cert -gt 0 ]] ;then
         status="${status}\n CERT NOT VERIFIED"
    fi

else
    status=" TOMCAT INACTIVE"
    code=1
fi

if [[ -d /opt/tomcat/webapps/acow-webapp ]]; then
    isFolder="true"
    status="${status}\n FOLDER acow-webapp exist"
else
    status="${status}\n FOLDER acow-webapp not exist"
fi

echo "$status"
exit "$code"



#Connecting to localhost (localhost)|127.0.0.1|:5005... connected.
#HTTP request sent, awaiting response... 
#  HTTP/1.1 200 OK
#  Date: Mon, 21 Mar 2022 11:56:44 GMT
#  Content-Type: text/html
#  Server: Kestrel
#  Content-Length: 13278
#  Last-Modified: Fri, 12 Nov 2021 19:14:19 GMT
#  Accept-Ranges: bytes
#  ETag: "1d7d7f97de9445e"
#Length: 13278 (13K) [text/html]
#Saving to: ‘index.html.1’
#
#index.html.1        100%[===================>]  12,97K  --.-KB/s    in 0s      
#
#2022-03-21 08:56:45 (294 MB/s) - ‘index.html.1’ saved [13278/13278]

#Connecting to localhost (localhost)|127.0.0.1|:5005... failed: Connection refused.


#Connecting to 192.168.110.237:80... connected.
#HTTP request sent, awaiting response... 
#  HTTP/1.1 301 Moved Permanently
#  Server: nginx/1.21.6
#  Date: Mon, 21 Mar 2022 11:53:31 GMT
#  Content-Type: text/html
#  Content-Length: 169
#  Connection: keep-alive
#  Location: https://192.168.110.237/
#Location: https://192.168.110.237/ [following]
#--2022-03-21 07:53:31--  https://192.168.110.237/
#Connecting to 192.168.110.237:443... connected.
#ERROR: cannot verify 192.168.110.237's certificate, issued by ‘/C=US/ST=Denial/L=NY/O=Akkadianlabs/CN=www.akkadianlabs.com’:
#  Self-signed certificate encountered.
#    ERROR: certificate common name ‘www.akkadianlabs.com’ doesn't match requested host name ‘192.168.110.237’.
#To connect to 192.168.110.237 insecurely, use `--no-check-certificate'.

