#!/usr/bin/env bash


web_updater_file="acow-webapp.war"
current_web_folder=/opt/tomcat/webapps
current_tmp_release_folder=/opt/akkadian/data/tmp

code=0;
msg="";


    if [[ -f /opt/tomcat/webapps/acow-webapp/WEB-INF/applicationContext-mongo.xml ]]; then
        resultcpmongo=$(sudo yes | cp -Rf /opt/tomcat/webapps/acow-webapp/WEB-INF/applicationContext-mongo.xml /opt/akkadian/data/tmp/applicationContext-mongo.xml  2>&1)
        codemongo=$?

        if [ ${codemongo} -ne 0 ];
        then
            msg="${msg}\n ERROR: Can't Copy applicationContext-mongo.xml to /opt/akkadian/data/tmp/applicationContext-mongo.xml"
        fi
    else
	if [[ -d /opt/tomcat/webapps/acow-webapp ]]; then
            msg="${msg}\n WARNING: applicationContext-mongo.xml doesn't exist on acow-webapp "
        else
            msg="${msg}\n WARNING: doesn't exist acow-webapp "
        fi
    fi




    result=$(sudo sh /home/akkadianuser/scripts/stop_tomcat.sh);
    statustomcat=$(sudo systemctl status tomcat.service | grep Active)

    if [[ "${statustomcat}" == *"Active: failed"* ]] || [[ "${statustomcat}" == *"Active: inactive"* ]];
    then


        if [[ -f ${current_tmp_release_folder}/${web_updater_file} ]]; then
            if [[ -f ${current_web_folder}/${web_updater_file} ]]; then
                result=$(sudo rm ${current_web_folder}/${web_updater_file})&
                wait $!
            fi

            if [[ -d ${current_web_folder}/acow-webapp ]]; then
                result=$(sudo rm -Rf ${current_web_folder}/acow-webapp)&
                wait $!
            fi

            result=$(sudo mv ${current_tmp_release_folder}/${web_updater_file} ${current_web_folder}/) &
            wait $!
            resultmvwar=$?
            sleep 8
        


		    if [ "${resultmvwar}" -eq 0 ];
		    then
		        msg="${msg}\n INFO: war moved Succesfully!"; 

		        msgdrop=$(sudo mysql --defaults-extra-file=/home/akkadianuser/.my_aco.cnf -e "DROP DATABASE fp;" 2>&1 )
		        codedrop=$?
		        msgcreate=$(sudo mysql --defaults-extra-file=/home/akkadianuser/.my_aco.cnf -e "CREATE DATABASE fp;" 2>&1 )
		        codecreate=$?

		        if [[ $codedrop == 0 && $codecreate == 0 ]]; 
		        then

		            # CW tunning up
		            # sudo cp -Rf /etc/systemd/system/multi-user.target.wants/mysqld.service
		            # sudo cp -Rf /home/akkadianuser/upgrades/aco_system_mysql_cnf/my.cnf /etc/my.cnf
		            # sudo systemctl restart mysqld

		            result=$(sudo chmod -R 0666 /opt/tomcat/logs)
		            result=$(sudo rm -rf /opt/tomcat/logs/*)

		            #sudo sh /home/akkadianuser/scripts/start_tomcat.sh
		            # In case mongo is part of a replica


		            result=$(sudo systemctl start tomcat.service)&
		            wait $!

			    sleep 5
		            statustomcat=$(sudo systemctl status tomcat.service | grep Active)

			    

			    if [[ "${statustomcat}" == *"Active: active"* ]];
			    then

			       result=$(sudo sh /home/akkadianuser/scripts/stop_tomcat.sh);
			       statustomcat=$(sudo systemctl status tomcat.service | grep Active)

                            


			       if [[ -f /opt/akkadian/data/tmp/applicationContext-mongo.xml ]]; then
				        if [[ -d /opt/tomcat/webapps/acow-webapp/WEB-INF/ ]]; then
				            resultcpmongo=$(sudo yes | cp -Rf /opt/akkadian/data/tmp/applicationContext-mongo.xml  /opt/tomcat/webapps/acow-webapp/WEB-INF/applicationContext-mongo.xml  2>&1)
				            codemongo=$?

				            if [ $codemongo -ne 0 ]; then
				                msg="${msg}\n ERROR: Can't Copy applicationContext-mongo.xml "
				            fi

				        else
				            msg="${msg}\n WARNING: doesn't exist on acow-webapp "
				        fi
			       fi


			    else
		                msg="${msg}\n ERROR: Can't Restart Tomcat to unpackage acoweb :\n$result"
		                code=1
			    fi

		        else
		            msg="${msg}\n ERROR: Can't DROP and CREATE fp Database:\n$msgdrop\n$msgcreate"
		            code=1
		        fi

		    else 
		        msg="${msg}\n ERROR: moving war to tomcat: ${current_tmp_release_folder}/${web_updater_file}  to  ${current_web_folder} : code ${resultmvwar}"
		        code=1
		    fi

        else
            msg="${msg}\n ERROR: ${current_tmp_release_folder}/${web_updater_file} doesn't exist "; 
            resultmvwar=1
        fi

    else
        msg="${msg}\n ERROR: Can't stop tomcat service"
        code=1
    fi




echo "${msg}"
exit $code

