#!/usr/bin/env bash

current_tomcat_base_folder=/opt/tomcat
current_tmp_release_folder=/opt/akkadian/data/tmp
current_server_folder=/opt/akkadian/aco-server

server_updater_file="acoserver.tar.gz"

code=0
msg=""
jtapiurl="$1"

msg="${msg}\n INFO: ${jtapiurl} $1"

if [ -f /opt/akkadian/aco-server/certificates/aco-server.crt ]; then
  sudo yes | cp -Rf /opt/akkadian/aco-server/certificates/aco-server.crt /opt/akkadian/data/tmp/aco-server.crt
else
  msg="${msg}\n ERROR: aco-server.crt don't exist"
  code=1
fi

if [ -f /opt/akkadian/aco-server/certificates/aco-server.key ]; then
  sudo yes | cp -Rf /opt/akkadian/aco-server/certificates/aco-server.key /opt/akkadian/data/tmp/aco-server.key
else
  msg="${msg}\n ERROR: aco-server.key don't exist"
  code=1
fi

if [[ -f /opt/akkadian/aco-server/certificates/aco-server.csr ]]; then
  sudo yes | cp -Rf /opt/akkadian/aco-server/certificates/aco-server.csr /opt/akkadian/data/tmp/aco-server.csr
else
  msg="${msg}\n ERROR: aco-server.csr don't exist"
  code=1
fi

# in case mongo is set with replica
if [[ -f /opt/akkadian/aco-server/scripts/start-mongodb.sh ]]; then
  sudo yes | cp -Rf /opt/akkadian/aco-server/scripts/start-mongodb.sh /opt/akkadian/data/tmp/start-mongodb.sh
else
  msg="${msg}\n WARNING: NO REPLICA. /opt/akkadian/aco-server/scripts/start-mongodb.sh file doesn't exist"
fi

# sudo sh /home/akkadianuser/scripts/stop_kestrel.sh
msg="${msg}\n INFO:Extracting  ${current_tmp_release_folder}/${server_updater_file}  to ${current_server_folder} "

res=$(sudo tar -xvzf ${current_tmp_release_folder}/${server_updater_file} -C ${current_server_folder}/ --strip-components 1 2>&1) &
wait $!
resultextract=$?

if [ "${resultextract}" -eq 0 ]; then
  msg="${msg}\n INFO: Extract Succesfull!"
  code=0

  resdostounix1=$(dos2unix ${current_server_folder}/scripts/* 2>&1) &
  wait $!

  resdostounix1=$(dos2unix ${current_server_folder}/configs/* 2>&1) &
  wait $!

  sudo chmod -R 765 /opt/akkadian/

  #in case we have replica
  if [[ -f /opt/akkadian/data/mongokey ]]; then
    sudo chmod 600 /opt/akkadian/data/mongokey
  else
    msg="${msg}\n WARNING: NO REPLICA. mongokey file doesn't exist"
  fi

  msg="${msg}\n INFO: Copying config files..."

  sudo yes | cp -Rf /opt/akkadian/aco-server/configs/sysctl.conf /etc/sysctl.conf
  sudo yes | cp -Rf /opt/akkadian/aco-server/configs/limits.conf /etc/security/limits.conf
  sudo yes | cp -Rf /opt/akkadian/aco-server/configs/supervisord.conf /etc/supervisord.conf
  sudo yes | cp -Rf /opt/akkadian/aco-server/configs/aco-server.service /etc/systemd/system/

  sudo yes | cp -Rf /opt/akkadian/aco-server/configs/nginx.conf /etc/nginx/
  sudo yes | cp -Rf /opt/akkadian/aco-server/configs/40x.html /usr/share/nginx/html/
  sudo yes | cp -Rf /opt/akkadian/aco-server/configs/50x.html /usr/share/nginx/html/
  sudo yes | cp -Rf /opt/akkadian/aco-server/configs/404.html /usr/share/nginx/html//
  sudo yes | cp -Rf /opt/akkadian/aco-server/configs/aCO-icon.png /usr/share/nginx/html/
  sudo yes | cp -Rf /opt/akkadian/aco-server/configs/aCO_Logo_big.svg /usr/share/nginx/html/

  #####  getting environment type, it can be empty if it is an old file
  msg="${msg}\n INFO: getting environment type, it can be empty if it is an old file"
  env=$(sudo cat /opt/tomcat/conf/fp-akkadian-platform.properties | grep aco.web.environment.size | awk -F "=" '{print $2}')
  sudo yes | cp -Rf ${current_server_folder}/acow-installer/fp-akkadian-platform.properties ${current_tomcat_base_folder}/conf/

  ####  setting environment type
  if [[ (-z "$env") || ("$env" == " ") || ("$env" == "\n") ]]; then
    msg="${msg}\n INFO: $env is empty"
  else
    sudo sed -i "s/aco.web.environment.size.*/aco.web.environment.size=$env/g" /opt/tomcat/conf/fp-akkadian-platform.properties
  fi

  sudo yes | cp -Rf ${current_server_folder}/acow-installer/server.xml ${current_tomcat_base_folder}/conf/

  msg="${msg}\n INFO: Getting jtapi from: ${jtapiurl}"

  responseJtapi=$(sudo /usr/bin/wget ${jtapiurl} -O /home/akkadianuser/jtapi.jar --no-check-certificate 2>&1) &
  wait $!
  coderesponsejtapi=$?

  if [ "${coderesponsejtapi}" -eq 0 ]; then

    sudo yes | cp -Rf /home/akkadianuser/jtapi.jar ${current_tomcat_base_folder}/lib/jtapi-9.1.jar

    sudo rm -Rf /home/akkadianuser/jtapi.jar
    sleep 5
    sudo yes | cp -Rf ${current_server_folder}/acow-installer/jtapi.ini ${current_tomcat_base_folder}/lib/
  else # if not, keep the current local one
    msg="${msg}\n INFO: Getting /etc/systemd/system/tomcat.service memory and save it"
    memory=$(sudo cat /etc/systemd/system/tomcat.service | grep "Environment='CATALINA_OPTS")
    sudo yes | cp -Rf ${current_server_folder}/configs/tomcat.service /etc/systemd/system/
    #setting memory into new file
    sudo sed -i "s/Environment="\'"CATALINA_OPTS.*/$memory/g" /etc/systemd/system/tomcat.service

    sudo yes | cp -Rf ${current_server_folder}/configs/my.cnf /etc/
    sudo yes | cp -Rf ${current_server_folder}/configs/mysqld.service /usr/lib/systemd/system/

    msg="${msg}\n INFO: Reloading daemon..."
    sudo systemctl daemon-reload

    msg="${msg}\n INFO: Changing permissions over the replica file"
    if [[ ! -f /opt/akkadian/data/replica ]]; then
      sudo echo " " >/opt/akkadian/data/replica
      sudo chmod 666 /opt/akkadian/data/replica
    else
      if [[ -f /opt/akkadian/data/mongokey ]]; then
        sudo chmod 600 /opt/akkadian/data/mongokey
      else
        msg="${msg}\n WARNING: NO REPLICA. mongokey file doesn't exist. "
      fi
      sudo chmod 666 /opt/akkadian/data/replica

    fi

    msg="${msg}\n INFO: Restoring certificates"

    sudo yes | cp -Rf /opt/akkadian/data/tmp/aco-server.crt /opt/akkadian/aco-server/certificates/aco-server.crt
    sudo yes | cp -Rf /opt/akkadian/data/tmp/aco-server.key /opt/akkadian/aco-server/certificates/aco-server.key
    if [[ -f /opt/akkadian/data/tmp/aco-server.csr ]]; then
      sudo yes | cp -Rf /opt/akkadian/data/tmp/aco-server.csr /opt/akkadian/aco-server/certificates/aco-server.csr
    fi
  fi

else
  msg="${msg}\n ERROR: Extract failed for file: ${current_tmp_release_folder}/${server_updater_file} : code ${coderesponsejtapi} : ${responseJtapi}"
  code=1
fi

# in case mongo is set with replica
if [[ -f /opt/akkadian/data/tmp/start-mongodb.sh ]]; then
  sudo yes | cp -Rf /opt/akkadian/data/tmp/start-mongodb.sh /opt/akkadian/aco-server/scripts/start-mongodb.sh
else
  msg="${msg}\n WARNING: NO REPLICA. /opt/akkadian/data/tmp/start-mongodb.sh file doesn't exist. "
fi

echo "${msg}"
exit $code
