#!/usr/bin/env bash

updater_file="aco.tar.gz"
#updater_encrypted_file="aco_server_web.tar.gz.gpg"
updater_encrypted_file="aco.tar.gz.gpg"
current_tmp_release_folder=/opt/akkadian/data/tmp


if [ ! -e /opt/akkadianuser/scripts/security/installationkey ]; then
   echo "ERROR: key file doesn't exit"
   exit 1
fi

if [ !  -d ${current_tmp_release_folder} ]; then
   echo "ERROR: temp folder doesn't exit"
   exit 1
fi

if [ ! -e ${current_tmp_release_folder}/${updater_encrypted_file} ]; then
   echo "ERROR: gpg encrypted file doesn't exit"
   exit 1
fi


gpg --batch --passphrase-file=/home/akkadianuser/scripts/security/installationkey --output ${current_tmp_release_folder}/${updater_file} --decrypt ${current_tmp_release_folder}/${updater_encrypted_file} & 
wait $!
resultgpg=$?


if [ "${resultgpg}" -eq 0 ];
then
  echo "Decryption Succesfull!"; 
  exit 0
else 
  echo "ERROR: Decryption failed for file: ${current_tmp_release_folder}/${updater_file}  from  ${current_tmp_release_folder}/${updater_encrypted_file} : code ${resultgpg}"
  exit 1
fi


