from ReplicaFailoverServerThread import ReplicaFailoverServerThread
from ReplicaFailoverClientThread import ReplicaFailoverClientThread
import socket
from MariaDBAndGaleraHelper import MariadbGaleraHelper
import logging
import sys
sys.path.append("/home/akkadianuser")
import configparser

logconfig = configparser.RawConfigParser()
logconfig.read('/home/akkadianuser/logs-config.ini')
loglevel = logconfig.get('General', 'galera-replication')

log_level = int(loglevel)
logging.basicConfig(format='%(asctime)s %(levelname)-8s %(message)s', filename='/home/akkadianuser/logs/galera_failover_recovery.log', level=log_level, datefmt='%Y-%m-%d %H:%M:%S')

credentialsconfig = configparser.RawConfigParser()
credentialsconfig.read('/home/akkadianuser/.my.cnf')
mariadb_user = credentialsconfig.get('client', 'user')
mariadb_password = credentialsconfig.get('client', 'password')

logging.debug('Main recovery script initiated...')
client_thread = None



def nodesFromFileToList():
    logging.debug('Reading load_balancer.config...')
    log_file_path = '/home/akkadianuser/load_balancer.config'
    nodes = []
    try:

        with open(log_file_path, 'r') as f:
            for line in f:
                line = line.strip().rstrip()
                nodes = nodes + line.split(" ")
    except Exception as e:
        return []

    return nodes


def tryClientNewConnection(nodes):
    # I'm the client of this communication
    logging.debug('I\'m the client of this communication')
    logging.debug('Starting main script as Client...')
    client_thread = ReplicaFailoverClientThread(nodes[0], 64333)
    client_thread.start()


port_base = 64333
nodes = nodesFromFileToList()
if nodes == []:
    logging.debug('There is no node in the load_balancer.config file, please ask the adminitrator')
    exit()
# if FQDN is needed => socket.getfqdn()
myself = socket.gethostname()
nodes_minus_myself = [item for item in nodes if item not in myself]

# create server for it
if myself == nodes[0]:
    # I'm the server of this communication
    logging.debug('I\'m the server of this communication')
    server_thread = ReplicaFailoverServerThread(64333)
    server_thread.start()
    # if client is connected in the other side, ensure the client connects again and everything is working:
    mariadbHelper = MariadbGaleraHelper(mariadb_user, mariadb_password)
    is_client_working = mariadbHelper.isClientSideWorking(nodes[1])
    if is_client_working.find("active (running)") > -1:
        # restart it so we ensure a fast recovery
        mariadbHelper.restartClientSideRemote(nodes[1])


else:
    # I'm the client of this communication
    tryClientNewConnection(nodes)
