import configparser
import logging
import mariadb
import sched,time
from src.ha_handler.ha_handler import send_email
import threading
from MariaDBAndGaleraHelper import MariadbGaleraHelper


logconfig = configparser.RawConfigParser()
logconfig.read('/home/akkadianuser/logs-config.ini')
loglevel = logconfig.get('General', 'galera-replication')
log_level = int(loglevel)

logging.basicConfig(format='%(asctime)s %(levelname)-8s %(message)s', filename='/home/akkadianuser/logs/galera_failover_recovery.log', level=log_level, datefmt='%Y-%m-%d %H:%M:%S')
credentialsconfig = configparser.RawConfigParser()
credentialsconfig.read('/home/akkadianuser/.my.cnf')
mariadb_user = credentialsconfig.get('client', 'user')
mariadb_password = credentialsconfig.get('client', 'password')

SEND_EMAIL_TIME = 5 * 60

class ReplicaFailover:

    def __init__(self):
        self.email_sch = sched.scheduler(time.time, time.sleep)
        logging.debug("Super class")

    def send_notify_node_down(self):
        try:
            notification_list = self.email_sch.queue
            if not notification_list:
                self.email_sch.enter(SEND_EMAIL_TIME, 1, send_email(), (self.email_sch,))
                t = threading.Thread(target=self.email_sch.run)
                t.start()
        except:
            logging.debug("Email cannot be sent...")


    def cancel_notify_node_down(self):
        try:
            self.email_sch.cancel(self.email_sch)
        except ValueError as ve:
            logging.debug('Trying to cancel unexisting event: cancel_notify_node_down')
        except Exception as e:
            logging.debug('Exception canceling email ')


    def connected_made_on_client(self):
        logging.debug('connection made on client, checking mariadb status')
        mariadb_recover = MariadbGaleraHelper(mariadb_user, mariadb_password)
        data_received = mariadb_recover.statusMariadb()

        logging.debug('data_received: ' + data_received[0])
        while data_received[0].find("Active: failed") != -1 or data_received[0].find("Active: inactive (dead)") != -1:
            logging.debug('mariadb in client is down')
            time.sleep(15)
            mariadb_recover.startMariadb()
            time.sleep(3)
            data_received = mariadb_recover.statusMariadb()


    def connected_made_on_server(self, host):
        logging.debug('connection made on server, checking mariadb status')
        mariadb_recover = MariadbGaleraHelper(mariadb_user, mariadb_password)
        mariadb_recover.connect()
        mariadb_recover.checkStatusAndIfNeededRestartClusterWhenAllNodesUp(host)


    def recover_mariadb_one_node(self):
        logging.debug('recovering one node')
        mariadb_recover = MariadbGaleraHelper(mariadb_user, mariadb_password)

        data_received = mariadb_recover.statusMariadb()
        if data_received[0].find("active (running)") != -1:
            mariadb_recover.connect()
            try:
                logging.debug('setting bootstrapping variables on this node')
                mariadb_recover.setBootstrapVariable()
            except mariadb.OperationalError as op_error:
                logging.debug('Error: ' + op_error)
            finally:
                mariadb_recover.disconnect()
        else:
            if data_received[0].find("active (running)") == -1:
                mariadb_recover.killMariadb()
                mariadb_recover.stopMariadb()
                time.sleep(3)
                mariadb_recover.bootstrapMariadb()
            else:
                mariadb_recover.startMariadb()
                data_received = mariadb_recover.statusMariadb()

                if data_received[0].find("active (running)") == -1:
                    mariadb_recover.killMariadb()
                    mariadb_recover.stopMariadb()
                    time.sleep(3)
                    mariadb_recover.bootstrapMariadb()
