Galera Replica Failure Engine is a new Akkadian Labs module that improves
the recovery task in an HA environment. In particular, it is intended to minimize the 
brain split problem when the cluster is composed of 2 nodes.

There are several features included as part of this module:

When galera replication, a new service replica-failover is installed.
The process opens ports: 65432 and 64333

The replica-failover service acts as server and client based on HA configurations.
The server side is in charge of detecting new connections and react to handle connection
problems, based on these, recovers mariadb and apply new configurations needed to keep working

The technology used is tcp sockets and a keep alive mechanism was needed to detect possible
failures in the connectivity. To do so there is a Factory module which auto-reconnects 
clients with an exponential back-off.
In order to reconnect there is a factor number and a initialDelay

    @ivar initialDelay: Delay for the first reconnection attempt.
    @ivar factor: A multiplicitive factor by which the delay grows in our case 1.7

The supported scenarios are:
Node failures, power outages and Network outages.
There are conditions in which we cannot avoid the split brain problem:
When the network is off an email is sent to the administrator, if during the period of
time in which one node is acting like standalone, and does not reach the other one, 
the data added in this node can be lost. This is the only moment in which we don't handle
the split brain problem.