#!/usr/bin/env bash
product=$2

rm -Rf *.tar.gz

hash=$(git rev-parse --short HEAD)
v=$(echo 'aam_version=4.2.1.'$1'-'$hash)
vv=$(echo '4.2.1.'$1'-'$hash)
version=$(echo "$v")

#MACOS
#sed -i '' "s/^aam_version=.*/$version/g" mapper.ini
#LINUX
sed -i "s/aam_version=.*/$version/g" mapper.ini

mkdir dependencies
base=$(echo "http://192.168.110.5/dependencies/cli/")
curl $base"jq-1.6-2.el7.x86_64.rpm" --output dependencies/jq-1.6-2.el7.x86_64.rpm

sudo rm -Rf tui-*.tar.gz

touch tui-$vv-$product.tar.gz

#old cli used sha256, new md5
echo "first parameter received is: $1"
echo "second parameter received is: $2"

sleep 5
echo "generating non enc file:"
echo "Product $product"

if [[ "$product" == "APM" ]]; then
    sudo rm -Rf packages/acm
    sudo rm -Rf packages/aco
    sudo cp -Rf packages/apm/* packages/
    sudo cp -Rf packages/apm_acm/* packages/
    sudo rm -Rf packages/apm_acm
    sudo rm -Rf packages/apm

elif [[ "$product" == "ACM" ]]; then
    sudo rm -Rf packages/apm
    sudo rm -Rf packages/aco
    sudo cp -Rf packages/acm/* packages/
    sudo cp -Rf packages/apm_acm/* packages/
    sudo rm -Rf packages/apm_acm
    sudo rm -Rf packages/acm

elif [[ "$product" == "ACO" ]]; then
    sudo rm -Rf packages/apm_acm
    sudo rm -Rf packages/apm
    sudo rm -Rf packages/acm
    sudo cp -Rf packages/aco/* packages/
    sudo rm -Rf packages/aco

fi
sleep 3
tar --exclude='.git' --exclude='.idea' --exclude='.DS_Store' --exclude='tmp/' --exclude=tui-$vv-$product.tar.gz --exclude=tui-$vv-enc.tar.gz -zcvf tui-$vv-$product.tar.gz .
