from subprocess import Popen, PIPE

import click
import re

import configparser
mapper = configparser.RawConfigParser()
mapper.read('mapper.ini')


def see_ldap_settings():
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'seeOpenLDAPSettings')], stdout=PIPE, stderr=PIPE)
        lines = []
        for line in p.stdout:
            line = line.decode("utf-8")
            lines.append(line)
            print(line)

        click.pause("Please press any key to continue")


    except Exception as e:
        print(e)
    return False


def set_olcSizeLimit(limit):
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'ldapOrcSizeLimit'), limit], stdout=PIPE, stderr=PIPE)

        for line in p.stdout:
            line = line.decode("utf-8")
            print(line)
        for line in p.stderr:
            print(line)

        click.pause('OpenLdap Size Limit changed, press any key to continue...')

    except Exception as e:
        print(e)

    return


def set_openldap_page(size):
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'setOpenLdapPageSize'), size], stdout=PIPE, stderr=PIPE)

        for line in p.stdout:
            line = line.decode("utf-8")
            print(line)
        for line in p.stderr:
            print(line)

        click.pause('OpenLdap Pahe Size Limit changed, press any key to continue...')

    except Exception as e:
        print(e)

    return


def change_ldap_basedn(new_base_dn):
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'changeOpenLDAPBaseDN'), new_base_dn], stdout=PIPE, stderr=PIPE)
        lines = []
        for line in p.stdout:
            line = line.decode("utf-8")
            lines.append(line)
            print(line)

        click.pause("Please press any key to continue")

    except Exception as e:
        print(e)

    return


def is_valid_ldap_basename(basename):
    try:
        res = re.match('^(dc=[0-9a-zA-Z]+\,{0,1})*$', str(basename))
        # click.secho('res:' + str(res))
        return (res != None and res != False)

    except Exception:
        click.secho('ERROR:' + str(Exception))
        return False