import socket
import subprocess
import time
import netifaces
import re
from subprocess import PIPE, Popen

import click

import configparser
mapper = configparser.RawConfigParser()
mapper.read('mapper.ini')


def modify_config_file(infile, config_to_update, value_to_update):
    lines_new = []
    lines = open(infile, 'r').readlines()
    for line in lines:
        line_words = line.split('=')
        for i in range(len(config_to_update)):
            if line_words[0] == config_to_update[i]:
                line_words[1] = value_to_update[i]
                line = line_words[0] + '=' + line_words[1] + '\n'
                break

        lines_new = lines_new + [line]

    outfile = open(infile, 'w')
    outfile.writelines(lines_new)


def nmtui():
    p = subprocess.call(["nmtui"])


def is_valid_ip(ip):
    # try:
    #     socket.inet_aton(ip)
    #     return True

    # except:

    #     return False
    try:
        parts = ip.split('.')
        return len(parts) == 4 and all(0 <= int(part) < 256 for part in parts)
    except ValueError:
        return False  # one of the 'parts' not convertible to integer
    except (AttributeError, TypeError):
        return False  # `ip` isn't even a string


def has_configured_ipv6(interface):
    p = subprocess.Popen(["sh", mapper.get('NetworkScripts', 'hasAlreadyConfiguredIPV6'), interface], stdout=PIPE,
                         stderr=PIPE)

    i = 0
    for line in p.stdout:
        line = line.decode("utf-8")
        i += 1

    if i > 0:
        return True
    else:
        return False


def get_current_hostname():
    p = subprocess.Popen(["sh", mapper.get('NetworkScripts', 'getHostname')], stdout=PIPE,
                         stderr=PIPE)

    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)


def change_hostname(new_host_name):
    p = subprocess.Popen(["sh", mapper.get('NetworkScripts', 'changeHostname'), new_host_name], stdout=PIPE,
                         stderr=PIPE)

    if p.returncode == 0 or p.returncode is None:
        click.secho('[OK] Hostname was changed successfully', fg="yellow")
    else:
        click.secho('[FAIL] Hostname could not be changed', fg="red")

    time.sleep(5)


def get_network_interface():
    p = subprocess.Popen(["sh", mapper.get('NetworkScripts', 'getNetworkInterfaces')], stdout=PIPE,
                         stderr=PIPE)
    interfaces = []
    for line in p.stdout:
        line = line.decode("utf-8")
        interfaces.append(line)

    return interfaces


def is_interface_up(interface):
    addr = netifaces.ifaddresses(interface)
    return netifaces.AF_INET in addr


def is_in_network(ip1, ip2, netmask):
    ip1_tmp, ip2_tmp = ip1.split("."), ip2.split(".")
    netmask_tmp = netmask.split(".")

    for i in range(3):
        subnet_ip1 = int(ip1_tmp[i]) & int(netmask_tmp[i])
        subnet_ip2 = int(ip2_tmp[i]) & int(netmask_tmp[i])

        if subnet_ip1 != subnet_ip2:
            return False

    return True


def check_ip_exist(interface, new_ip):
    if is_interface_up(interface):
        addrs = netifaces.ifaddresses(interface)
        actual_ip = addrs[netifaces.AF_INET][0].get('addr')
        netmask = addrs[netifaces.AF_INET][0].get('netmask')

        if is_in_network(actual_ip, new_ip, netmask):
            if actual_ip != new_ip:
                p = subprocess.Popen(["sh", mapper.get('NetworkScripts', 'checkIpExist'), new_ip], stdout=PIPE,
                                     stderr=PIPE)
                for line in p.stdout:
                    line = line.decode("utf-8")
                    if '0' in line:
                        return 1  # IP Taken
                    else:
                        return 0  # IP Free
            else:
                return 0  # IP Free
        else:
            if click.confirm('\nThe ip you are trying to use is outside the network.\n'
                             'IPv4 Address cannot be confirmed if used by another system.\n'
                             'Are you sure you want to use this IPV4 address?'):
                return 0  # IP Check Override with external ip
            else:
                click.echo(
                    'IP Configuration interrupted. Returning to Network Configuration Menu.\nPress any key to continue...')
                menu = 'network'
    else:
        if click.confirm('\nNetwork Interface is not currently enabled.\n'
                         'IPv4 Address cannot be confirmed if used by another system.\n'
                         'Are you sure you want to use this IPV4 address?'):
            return 0  # Authorize IP Check Override
        else:
            click.echo(
                'IP Configuration interrupted. Returning to Network Configuration Menu.\nPress any key to continue...')
            menu = 'network'


def get_ip():
    p = subprocess.Popen(["sh", mapper.get('NetworkScripts', 'getIp')], stdout=PIPE,
                         stderr=PIPE)
    ip = ''
    for line in p.stdout:
        line = line.decode("utf-8")
        ip = line

    return str(ip)


def network_stop(interface):
    p = subprocess.Popen(["sh", mapper.get('NetworkScripts', 'networkStop'), interface], stdout=PIPE,
                         stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Network could not be Stopped', fg="red")
    else:
        click.secho('[OK] Network Stopped Successfully', fg="yellow")

    time.sleep(5)


def network_start(interface):
    p = subprocess.Popen(["sh", mapper.get('NetworkScripts', 'networkStart'), interface], stdout=PIPE,
                         stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Network could not be Started', fg="red")
    else:
        click.secho('[OK] Network Started Successfully', fg="yellow")

    time.sleep(5)


def network_restart(interface):
    p = subprocess.Popen(["sh", mapper.get('NetworkScripts', 'networkRestart'), interface], stdout=PIPE,
                         stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Network Could Not be Restarted.', fg="red")
    else:
        click.secho('[OK] Network Restarted Successfully', fg="yellow")

    time.sleep(5)


def restart_network(ctx, interface):
    try:
        if click.confirm(
                'The network interface is about to restart, Are you sure you want to restart this network interface? If this is your primary network interface, you may lose connection to this command prompt. '):
            ctx.invoke(network_restart, interface)
        else:
            menu = 'network'
    except click.Abort:
        menu = 'network'


def edit_proxy():
    """Edit /etc/environment file"""
    click.edit(filename=mapper.get('GeneralConfigs', 'proxyFile'))


def modify_dns(infile, dns, new_value):
    click.echo(infile)
    lines = open(infile, 'r').readlines()
    if dns == 'dns1':
        lines[0] = "nameserver " + new_value + "\n"
    elif dns == 'dns2':
        lines[1] = "nameserver " + new_value + "\n"

    outfile = open(infile, 'a')
    outfile.writelines(lines)
    click.echo("lines wrote")


def get_simple_hostname():
    p = subprocess.Popen(["sh", mapper.get('NetworkScripts', 'getSimpleHostname')], stdout=PIPE,
                         stderr=PIPE)

    for line in p.stdout:
        line = line.decode("utf-8")
        return line



def is_valid_hostname(hostname):
    if hostname[-1] == ".":
        # strip exactly one dot from the right, if present
        hostname = hostname[:-1]
    if len(hostname) > 253:
        return False

    labels = hostname.split(".")

    # the TLD must be not all-numeric
    if re.match(r"[0-9]+$", labels[-1]):
        return False

    allowed = re.compile(r"(?!-)[a-z0-9-]{1,63}(?<!-)$", re.IGNORECASE)
    return all(allowed.match(label) for label in labels)



def is_fqdn(hostname):
    """
    :param hostname: string
    :return: bool
    """
    #  Remove trailing dot
    try:  # Is this necessary?
        if hostname[-1] == '.':
            hostname = hostname[0:-1]
    except IndexError:
        return False

    #  Check total length of hostname < 253
    if len(hostname) > 253:
        return False

    #  Split hostname into list of DNS labels
    hostname = hostname.split('.')

    #  Define pattern of DNS label
    #  Can begin and end with a number or letter only
    #  Can contain hyphens, a-z, A-Z, 0-9
    #  1 - 63 chars allowed
    fqdn = re.compile(r'^[a-z0-9]([a-z-0-9-]{0,61}[a-z0-9])?$', re.IGNORECASE)

    #  Check if length of each DNS label < 63
    #  Match DNS label to pattern
    for label in hostname:
        if len(label) > 63:
            return False
        if not fqdn.match(label):
            return False

    #  Found no errors, returning True
    return True





def get_domain(hostname):
    """
    :param hostname: string
    :return: None
    """

    if hostname == None:
        return None

    if "." not in hostname:
        return None


    hostname = hostname.split('.')
    if len(hostname) == 0:
        return None

    domain = None
    ini = True
    for label in hostname:
        if ini == False:
            if domain == None :
                domain = label
            else:
                domain = domain + "." + label
        ini = False

    return domain


def is_inside_domain(hostname,domain):

    hostnamedomain = get_domain(hostname)

    if hostnamedomain == None:
        return False

    if domain == None:
        return False

    return (hostnamedomain == domain)



def reach_ip(new_ip):
    # type: (object) -> object
    p = subprocess.Popen(["sh", mapper.get('NetworkScripts', 'checkIpExist'), new_ip], stdout=PIPE,
                         stderr=PIPE)

    result_last_line = ''

    for line in p.stdout:
        line = line.decode("utf-8")
        result_last_line = line;

    # if 100% packages sent, 0 lost is not in the string
    if 'True' in result_last_line:
        return True  # not reaching
    else:
        return False  # reaching


def is_ip(addr):
    try:
        socket.inet_aton(addr)
        return True
    except socket.error:
        return False


def ping(host):
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'ping'), host], stdout=PIPE, stderr=PIPE)

        for line in p.stdout:
            line = line.decode("utf-8")
            print(line)
        for line in p.stderr:
            print(line)

        click.pause('Please, press any key to continue...')

    except Exception as e:
        print(e)

    return


def write_new_configs(ip, dns1, dns2, netmask, gateway, dhcp, interface):
    click.echo('Saving Network configs...')
    configs_to_update = []
    values_to_update = []
    if ip != '':
        click.echo('Saving IP...')
        configs_to_update.append('IPADDR')
        values_to_update.append(ip)
    if netmask != '':
        click.echo('Saving Network NETMASK...')
        configs_to_update.append('NETMASK')
        values_to_update.append(netmask)
    if gateway != '':
        click.echo('Saving Network GATEWAY...')
        configs_to_update.append('GATEWAY')
        values_to_update.append(gateway)
    if dns1 != '':
        click.echo('Saving Network DNS1...')
        # modify_dns(mapper.get('GeneralConfigs', 'dns_file'), 'dns1', dns1)
        configs_to_update.append('DNS1')
        values_to_update.append(dns1)
    if dns2 != '':
        click.echo('Saving Network DNS2...')
        # modify_dns(mapper.get('GeneralConfigs', 'dns_file'), 'dns2', dns2)
        configs_to_update.append('DNS2')
        values_to_update.append(dns2)
    if dhcp != '':
        configs_to_update.append('BOOTPROTO')
        values_to_update.append(dhcp)
    if configs_to_update:
        modify_config_file(mapper.get('GeneralConfigs', 'network_interface_file') + interface, configs_to_update,
                           values_to_update)
        # shutil.copy(mapper.get('GeneralConfigs', 'network_interface_file'),
        #            mapper.get('GeneralConfigs', 'network_interface_tmp_file'))

def akkadian_repo_check_is_enabled():
    p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'akkadianRepoCheckIsEnabled')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        if 'True' in line:
            return True
        elif 'False' in line:
            return False

def set_akkadian_repo_check(check_repo):
    p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'setAkkadianRepoCheck'), check_repo], stdout=PIPE, stderr=PIPE)
    return

def toggle_akkadian_repo_check():
    set_akkadian_repo_check(str(not akkadian_repo_check_is_enabled()))
