import subprocess
from subprocess import PIPE
import click
import time

import configparser
mapper = configparser.RawConfigParser()
mapper.read('mapper.ini')


def add_mongo_replication():
    try:
        print('Adding Replication Configurations, please wait...')
        p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'setMongoReplication')], stdout=PIPE,
                             stderr=PIPE)
        lines = []
        for line in p.stdout:
            line = line.decode("utf-8")
            lines.append(line)
            print(line)

        print("Adding Mongo Replication -- Success")
        return

    except Exception as e:
        print(e)
    return


def mongo_replication_postconditions():
    try:
        p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'setMongoReplicationPostconditions')], stdout=PIPE,
                             stderr=PIPE)
        lines = []
        for line in p.stdout:
            line = line.decode("utf-8")
            lines.append(line)
            print(line)

        return

    except Exception as e:
        print(e)
    return


def remove_mongo_replication():
    try:
        print('Removing Replication Configurations, please wait...')
        p1 = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'openSsh')], stdout=PIPE, stderr=PIPE)
        p2 = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'permitRootAccessOn')], stdout=PIPE, stderr=PIPE)
        out, err = p1.communicate()
        time.sleep(3)

        for line in out.splitlines():
            print(line)

        for line in err.splitlines():
            print(line)

        out, err = p2.communicate()
        time.sleep(3)

        for line in out.splitlines():
            print(line)

        for line in err.splitlines():
            print(line)

        p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'removeMongoReplication')], stdout=PIPE,
                             stderr=PIPE)
        lines = []
        for line in p.stdout:
            line = line.decode("utf-8")
            lines.append(line)

        print("Removing Mongo Replication -- Success")
        return

    except Exception as e:
        print(e)
    return


def status_mongo_replication():
    try:
        p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'statusMongoReplication')], stdout=PIPE,
                             stderr=PIPE)
        lines = []
        for line in p.stdout:
            line = line.decode("utf-8")
            print(line)

        f = open("/home/akkadianuser/scripts/mongo_replica_scripts/status_output", "r")
        contents = f.read()
        print(contents)

        click.pause("Status Mongo Replication, please press any key to continue")
        return

    except Exception as e:
        print(e)
    return