import click

logs_path = None

try:
    import ConfigParser

    logs_path = ConfigParser.RawConfigParser()
    logs_path.read('logs.ini')

except ImportError:
    import configparser
    logs_path = configparser.RawConfigParser()
    logs_path.read('logs.ini')


def show_auu_installation_log():
    read_log('auu_installation')
    return


def show_auto_update_log():
    read_log('auto_update')
    return

def show_installation_pme_log():
    read_log('pme_installation')
    return

def show_installation_aco_log():
    read_log('aco_installation')
    return

def show_init_ha_log():
    read_log('init_ha')
    return

def show_init_replica_apm_log():
    read_log('init_replica')
    return

def show_init_replica_aco_log():
    read_log('init_replica_aco')
    return

def show_init_ha_log_aco():
    read_log('init_replica_aco')
    return

def show_ha_log_pme():
    read_log('ha_log_apm')
    return

def show_ha_log_aco():
    read_log('ha_log_aco')
    return

def read_log(log_path):
    log_file_path = logs_path.get('General', log_path)

    try:
        with open(log_file_path, 'r') as f:
            for line in f:
                line = line.strip().rstrip()
                click.secho(line, fg='green')
    except Exception as e:
        click.secho('The file does not exist', fg='green')

    click.pause('Please press any key to continue...')
    return
