import socket
from subprocess import Popen, PIPE
import logging
import base64

logging.basicConfig(filename='executor.log', level=logging.DEBUG)

logging.debug('about logging mapper.ini')

# This handle the python2 and python3 versions
try:
    import configparser

    mapper = configparser.RawConfigParser()
    mapper.read('mapper.ini')
except:
    import ConfigParser

    mapper = ConfigParser.RawConfigParser()
    mapper.read('mapper.ini')

HOST = '0.0.0.0'  # In this way we ensure nothing can connect from outside. 0.0.0.0 for any ip
PORT = 65432  # Port to listen, maybe there is a more secure port?

s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
s.bind((HOST, PORT))
s.listen(5)
while 1:
    (conn, addr) = s.accept()
    logging.debug('Connected by ' + str(addr))
    data = conn.recv(1024).decode("utf-8")
    if not data:
        logging.debug('There is no data in the message')
        break
    logging.debug('Data received ' + data)

    # example of message: isValidUserPass, GeneralScripts:isValidUserPass
    function_and_parameters = data.split(":")
    is_needed_wait = True
    mapper_to_use = ""
    section, function, params = "", "", []

    if mapper.has_section(function_and_parameters[0]):
        # it has section
        section = function_and_parameters[0]
        function = function_and_parameters[1]
        params = function_and_parameters[2:]
        if str.endswith(function, "Async"):
            function = function.rstrip("Async")
            is_needed_wait = False

        mapper_to_use = mapper.get(section, function)
    else:
        # it don't not have section and it is GeneralScript
        function = function_and_parameters[0]
        params = function_and_parameters[1:]

        if str.endswith(function, "Async"):
            function = function.rstrip("Async")
            is_needed_wait = False

        mapper_to_use = mapper.get('GeneralScripts', function)
        logging.debug('Data received ' + data)
    # function, params = function_and_parameters[0], function_and_parameters[1:]
    logging.debug('mapper to use: ' + mapper_to_use)

    response = ''

    if function == 'isValidUserPass':
        params[0] = base64.b64decode(params[0])
        params[1] = base64.b64decode(params[1])

    if function == 'acoUpdateScript':
        # cucm url is endoded
        params[1] = base64.b64decode(params[1])

    p = Popen(["sh", mapper_to_use] + params, stdout=PIPE, stderr=PIPE)

    if is_needed_wait:
        p.wait()

        for line in p.stdout:
            line = line.decode("utf-8")
            logging.debug(line)
            response = response + line

        for line in p.stderr:
            line = line.decode("utf-8")
            logging.debug(line)
            response = response + line

        logging.debug('Response is: ' + response)
    else:
        response = function + " triggered successfully"

    conn.send((response + "\r\n").encode("utf-8"))


