import smtplib
import configparser
import ssl

from email.message import EmailMessage
from src.ha_handler.ha_handler import get_redundancy_nodelist
from network_management import reach_ip
from src.cli_commons.commons_manager import installed_application


def send_email():
    email_config = False
    configs = configparser.RawConfigParser()
    try:
        configs.read('/home/akkadianuser/email_configs.ini')
        email_config = True
    except:
        email_config = False

    if email_config:

        send_email = configs.get('General', 'enable')
        if send_email:
            msg = EmailMessage()

            node_list = get_redundancy_nodelist()
            offline = ""
            online = ""

            nodes_list_array = node_list.split(' ')

            for i in range(0, len(nodes_list_array)):
                if reach_ip(nodes_list_array[i]):
                    online = online + " " + nodes_list_array[i]
                else:
                    offline = offline + " " + nodes_list_array[i]

            # GET THE NAME OF THE NODE DOWN.
            message = "HA Cluster connectivity to " + offline + " has been lost, please verify cluster status in Akkadian Appliance Manager"

            msg.set_content(message)

            installed_app = installed_application()
            name_to_show = ""
            if installed_app == 'aco':
                name_to_show = "Akkadian Console Operator"
            elif installed_app == 'pme_cm':
                name_to_show = 'Akkadian Provisioning Manager'
            elif installed_app == 'acm':
                name_to_show = 'Akkadian Contact Manager'

            msg['Subject'] = f'[ALERT] Server status: DOWN - ' + name_to_show

            msg['From'] = configs.get('General', 'sender')
            msg['To'] = configs.get('General', 'receiver')

            port = configs.get('General', 'port')  # For SSL
            password = configs.get('General', 'password')

            ssl_ = configs.get('General', 'is_ssl_enable')
            # Create a secure SSL context

            if ssl_ == "True":
                context = ssl.create_default_context()
                context.check_hostname = False
                context.verify_mode = ssl.CERT_NONE

            sender_email = configs.get('General', 'sender')
            receiver_email = configs.get('General', 'receiver')
            sever_add = configs.get('General', 'server')

            with smtplib.SMTP(sever_add, port) as server:
                if ssl_ == "True":
                    server.ehlo()
                    server.starttls(context=context)
                    server.ehlo()
                    server.login(sender_email, password)
                    server.send_message(msg)
                else:
                    if password != "":
                        server.login(sender_email, password)
                    server.send_message(msg)

                server.quit()
                print("Email Sent")

send_email()