import time
from subprocess import PIPE, Popen

import click
try:
    import configparser
except ImportError:
    import ConfigParser as configparser
    

mapper = configparser.RawConfigParser()
mapper.read('mapper.ini')


def cdr_stop():
    click.echo('Stopping...')
    p = Popen(["sh", mapper.get('ApplicationScripts', 'stopCDR')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] CDR Collector Service could not be stopped', fg="red")
    else:
        click.secho('[OK] CDR Collector Service stopped successfully', fg="yellow")

    time.sleep(3)


def cdr_start():
    click.echo('Starting...')
    p = Popen(["sh", mapper.get('ApplicationScripts', 'startCDR')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] CDR Collector Service could not be started', fg="red")
    else:
        click.secho('[OK] CDR Collector Service started successfully', fg="yellow")

    time.sleep(3)


def cdr_restart():
    click.echo('Restarting...')
    p = Popen(["sh", mapper.get('ApplicationScripts', 'restartCDR')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] CDR Collector Service could not be restarted', fg="red")
    else:
        click.secho('[OK] CDR Collector Service restarted successfully', fg="yellow")

    time.sleep(3)


def cdr_status():
    p = Popen(["sh", mapper.get('ApplicationScripts', 'getCDRStatus')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Akkadian CDR Collector Service status could not be retrieved', fg="red")

    click.pause('Please, press any key to continue...')


def edit_cdr_config():
    try:

        click.edit(filename='/usr/local/sbin/akk_cdr/akk_cdr_config.json')

        click.pause('Please, press any key to continue...')
    except:
        click.secho('[FAIL] There was an error while trying to access the config file')


def cdr_logs():
    try:
        p = Popen(["sh", mapper.get('ApplicationScripts', 'CDRLogs')], stdout=PIPE, stderr=PIPE)
        for line in p.stdout:
            line = line.decode("utf-8")
            print(line)
        p.wait()

        click.pause('Please, press any key to continue...')
    except:
        click.secho('[FAIL] There was an error while trying to view the CDR Collector logs')


def is_cdr_installed():
    try:
        p = Popen(["sh", mapper.get('ApplicationScripts', 'check_CDR')], stdout=PIPE, stderr=PIPE)
        for line in p.stdout:
            line = line.decode("utf-8")
            print(line)
        p.wait()

        if p.returncode == 0:
            # service found
            return True
        else:
            return False
    except:
        return False


def change_akksftpcdruser_pass():
    password = click.prompt('Enter akksftpcdruser new password', type=str, hide_input=True,
                            confirmation_prompt=True)
    while '\\' in password or '/' in password or '$' in password:
        click.pause('Password cannot have \\ nor / nor $, please press any key to continue')
        password = click.prompt('Enter akksftpcdruser new password', type=str, hide_input=True,
                                confirmation_prompt=True)

    if password != "":
        click.pause(
            "Your akksftpcdruser password is about to change. Please remember it or store in a secure location.")
        p = Popen(["sh", mapper.get("GeneralScripts", "changeakksftpcdruserPass"), password], stdout=PIPE,
                  stderr=PIPE)
        p.wait()
        response = ''
        for line in p.stdout:
            response = response + line

        click.pause("Press any key to continue....")

    return
