import time
from subprocess import PIPE, Popen

import click

try:
    import configparser
except ImportError:
    import ConfigParser as configparser

mapper = configparser.RawConfigParser()
mapper.read('mapper.ini')


def asm_stop():
    click.echo('Stopping...')
    p = Popen(["sh", mapper.get('ApplicationScripts', 'stopASM')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Akkadian Service Monitor could not be stopped', fg="red")
    else:
        click.secho('[OK] Akkadian Service Monitor stopped successfully', fg="yellow")

    time.sleep(3)


def asm_start():
    click.echo('Starting...')
    p = Popen(["sh", mapper.get('ApplicationScripts', 'startASM')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Akkadian Service Monitor could not be started', fg="red")
    else:
        click.secho('[OK] Akkadian Service Monitor started successfully', fg="yellow")

    time.sleep(3)


def asm_restart():
    click.echo('Restarting...')
    p = Popen(["sh", mapper.get('ApplicationScripts', 'restartASM')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Akkadian Service Monitor could not be restarted', fg="red")
    else:
        click.secho('[OK] Akkadian Service Monitor restarted successfully', fg="yellow")

    time.sleep(3)


def asm_status():
    p = Popen(["sh", mapper.get('ApplicationScripts', 'getASMStatus')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Akkadian Service Monitor status could not be retrieved', fg="red")

    click.pause('Please, press any key to continue...')

def edit_asm_config():
    try:

        click.edit(filename='/usr/local/sbin/asm/default_services')

        click.pause('Please, press any key to continue...')
    except:
        click.secho('[FAIL] There was an error while trying to access the config file')

def asm_logs():
    try:
        p = Popen(["sh", mapper.get('ApplicationScripts', 'ASMLogs')], stdout=PIPE, stderr=PIPE)
        for line in p.stdout:
            line = line.decode("utf-8")
            print(line)
        p.wait()

        click.pause('Please, press any key to continue...')
    except:
        click.secho('[FAIL] There was an error while trying to view the Akkadian Service Monitor logs')

def is_asm_installed():
    try:
        p = Popen(["sh", mapper.get('ApplicationScripts', 'check_ASM')], stdout=PIPE, stderr=PIPE)
        for line in p.stdout:
            line = line.decode("utf-8")
            print(line)
        p.wait()

        if p.returncode == 0:
            #service found 
            return True
        else:
            return False
    except:
        return False
