import time
from subprocess import Popen, PIPE

import click

import configparser
mapper = configparser.RawConfigParser()
mapper.read('mapper.ini')



def apache_stop():
    """
    Stop Apache Service
    """

    click.echo('Stopping...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'apacheStop')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Cannot reach apache, is it running?', fg="red")
    else:
        click.secho('[OK] Apache Server is down', fg="yellow")

    time.sleep(5)



def apache_start():
    """
    Start Apache Service
    """

    click.echo('Starting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'apacheStart')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Apache Could Not Be Started', fg="red")
    else:
        click.secho('[OK] Apache Started Successfully', fg="yellow")

    time.sleep(5)



def apache_restart():
    """
    Restart Apache Service
    """

    click.echo('Restarting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'apacheRestart')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Apache Could Not Be Restarted', fg="red")
    else:
        click.secho('[OK] Apache Restarted Successfully', fg="yellow")

    time.sleep(5)