import configparser
import os
import signal
import subprocess
import threading
from subprocess import PIPE

import click

from src.cli_commons.commons_manager import (
    change_akkadianuser_default_passwords, edit_email_configs,
    installed_application, kickoff_this_user, reboot,
    run_after_aam_installation_needed_scripts, send_email_test,
    show_select_option, shutdown)
from src.ha_handler.ha_handler import (
    edit_email_configs, edit_replica_failover_logs_configs, is_full_ha_mode,
    is_mastermaster_mastersalve_replication_enabled, is_replication_mode_only,
    maintenance_mode_on, turn_off_replica_failover_logs, turn_on_replica_failover_logs,
    clean_replica_failover_logs,maintenance_is_mode_on, maintenance_mode_off,remove_full_ha,
    restart_replica_failover_status,send_email_test, show_replica_failover_logs,
    show_replica_failover_status, start_full_ha, start_replication, maintenance_mode_prompt,
    disable_replication_prompt
)
from src.menu_renderer.aam_menu_manager import (handle_auto_update_selection,
                                                render_aam_management_menu)
from src.menu_renderer.galera_menu_manager import (render_galera_management_menu)
from src.menu_renderer.aco_detailed_service_menu_manager import (
    aco_detailed_services_menu_handler, aco_services_detailed_menu)
from src.menu_renderer.aco_mysql_menu_manager import (aco_mysql_menu,
                                                      aco_mysql_menu_handler)
from src.menu_renderer.aco_services_menu_manager import (
    aco_services_menu, aco_services_menu_handler)
from src.menu_renderer.akkadian_executor_menu_manager import (
    handle_akkadian_executor_selection, render_akkadian_executor_menu)
from src.menu_renderer.apache_menu_manager import (apache_menu,
                                                   apache_menu_handler)
from src.menu_renderer.apm_acm_services_menu_manager import (
    apm_acm_services_menu, apm_acm_services_menu_handler)
from src.menu_renderer.asm_menu_manager import asm_menu, asm_menu_handler
from src.menu_renderer.auu_menu_manager import auu_menu, auu_menu_handler
from src.menu_renderer.cdr_menu_manager import cdr_menu, cdr_menu_handler
from src.menu_renderer.general_product_view_menu_manager import (
    handle_general_menu_selection_manager, render_general_view_products_menu)
from src.menu_renderer.logs_menu_manager import (handle_logs_menu_selection,
                                                 render_logs_menu)
from src.menu_renderer.main_menu_manager import (
    handle_main_menu_selection, render_ha_main_view, render_main_menu,
    set_main_menu_margin_and_style)
from src.menu_renderer.mongo_menu_manager import mongo_menu, mongo_menu_handler
from src.menu_renderer.mysql_menu_manager import mysql_menu, mysql_menu_handler
from src.menu_renderer.network_menu_manager import (network_menu,
                                                    network_menu_handler)
from src.menu_renderer.nginx_menu_manager import nginx_menu, nginx_menu_handler
from src.menu_renderer.ntp_sync_menu_manager import (
    handle_ntp_sync_servers_menu, ntp_sync_server_menu,
    review_ntp_servers_handler)
from src.menu_renderer.openldap_menu_manager import (openldap_menu,
                                                     openldap_menu_handler)
# Handle menus
from src.menu_renderer.performance_menu_manager import \
    hanlde_server_performance_menu
from src.menu_renderer.security_menu_manager import (render_security_menu,
                                                     security_menu_handler)
from src.menu_renderer.supervisor_menu_manager import (supervisor_menu,
                                                       supervisor_menu_handler)
from src.menu_renderer.time_menu_manager import (handle_time_menu,
                                                 render_time_menu)
from src.menu_renderer.tomcat_menu_manager import (tomcat_menu,
                                                   tomcat_menu_handler)
from src.menu_renderer.update_acm_menu_manager import (update_acm_menu,
                                                       update_acm_menu_handler)
from src.menu_renderer.update_aco_menu_manager import (update_aco_menu,
                                                       update_aco_menu_handler)
from src.menu_renderer.update_apm_menu_manager import (pme_installation_menu,
                                                       pme_menu_handler)
from src.products_installation_handler.products_installation_manager import (
    auto_update, getUpdate_name, install_aco_from_url, pme_from_file_handler,
    pme_from_url_handler, push_pme_cm_another_node,
    there_is_a_cli_update_in_folder)

mapper = configparser.RawConfigParser()
mapper.read('mapper.ini')


class Config:
    """The config in this example only holds aliases."""

    def __init__(self):
        self.path = os.getcwd()
        self.aliases = {}

    def add_alias(self, alias, cmd):
        self.aliases.update({alias: cmd})

    def read_config(self, filename):
        parser = configparser.RawConfigParser()
        parser.read([filename])
        try:
            self.aliases.update(parser.items("akkadianAppManager"))
        except configparser.NoSectionError:
            pass

    def write_config(self, filename):
        parser = configparser.RawConfigParser()
        parser.add_section("aliases")
        for key, value in self.aliases.items():
            parser.set("aliases", key, value)
        with open(filename, "wb") as file:
            parser.write(file)


pass_config = click.make_pass_decorator(Config, ensure=True)


class AliasedGroup(click.Group):
    """This subclass of a group supports looking up aliases in a config
    file and with a bit of magic.
    """

    def get_command(self, ctx, cmd_name):
        # Step one: bulitin commands as normal
        rv = click.Group.get_command(self, ctx, cmd_name)
        if rv is not None:
            return rv

        # Step two: find the config object and ensure it's there.  This
        # will create the config object is missing.
        cfg = ctx.ensure_object(Config)

        # Step three: look up an explicit command alias in the config
        if cmd_name in cfg.aliases:
            actual_cmd = cfg.aliases[cmd_name]
            return click.Group.get_command(self, ctx, actual_cmd)

        # Alternative option: if we did not find an explicit alias we
        # allow automatic abbreviation of the command.  "status" for
        # instance will match "st".  We only allow that however if
        # there is only one command.
        matches = [
            x for x in self.list_commands(ctx) if x.lower().startswith(cmd_name.lower())
        ]
        if not matches:
            return None
        elif len(matches) == 1:
            return click.Group.get_command(self, ctx, matches[0])
        ctx.fail('Too many matches: %s' % ', '.join(sorted(matches)))


def read_config(ctx, param, value):
    """Callback that is used whenever --config is passed.  We use this to
    always load the correct config.  This means that the config is loaded
    even if the group itself never executes so our aliases stay always
    available.
    """
    cfg = ctx.ensure_object(Config)
    if value is None:
        value = os.path.join(os.path.dirname(__file__), "aliases.ini")
    cfg.read_config(value)
    return value


@click.command(cls=AliasedGroup)
@click.option(
    "--config",
    type=click.Path(exists=True, dir_okay=False),
    callback=read_config,
    expose_value=False,
    help="The config file to use instead of the default.",
)
def cli():
    """Akkadian Appliance Manager"""


@cli.command()
@click.pass_context
def menu(ctx):
    """Shows the Akkadian Appliance menu."""
    menu = 'main'
    ip = ''
    dns1 = ''
    dns2 = ''
    netmask = ''
    gateway = ''
    values_to_update = []
    interface = 'ens160'
    char = ''
    dhcp = None
    installed_app = ''

    try:

        installed_app = installed_application()
        # Because this is starting
        # Cleanning master to be determined next time
        clean_old_master = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'truncateMaster')], stdout=PIPE,
                                            stderr=PIPE)

        for line in clean_old_master.stdout:
            old_master = line

        replication_type = "general"

        download_thread = threading.Thread(target=run_after_aam_installation_needed_scripts)
        download_thread.start()

        change_akkadianuser_default_passwords()

        main_menu(char, ctx, dns1, dns2, gateway, interface, ip, menu, netmask, dhcp, values_to_update, installed_app,
                  replication_type)

    except click.Abort:
        menu = 'main'
        main_menu(char, ctx, dns1, dns2, gateway, interface, ip, menu, netmask, dhcp, values_to_update, installed_app,
                  replication_type)

    except KeyboardInterrupt:
        menu(ctx)


def main_menu(char, ctx, dns1, dns2, gateway, interface, ip, menu, netmask, dhcp, values_to_update, installed_app,
              replication_type):

    while 1:
        try:
            if menu == 'main':
                set_main_menu_margin_and_style()
                there_is_a_cli_update_in_folder_var = there_is_a_cli_update_in_folder()
                if there_is_a_cli_update_in_folder_var:
                    file_name = getUpdate_name()
                    click.secho('New CLI update: ' + file_name, fg='green')
                    if click.confirm('Do you want to install it now?'):
                        # run it now!!
                        click.secho('CLI is being updated, please wait...', fg='green')
                        ctx.invoke(auto_update, "cli_updates")

                else:
                    render_main_menu(char, installed_app, menu)

                    char = show_select_option(char)
                    menu = handle_main_menu_selection(char, installed_app, menu)

            elif menu == 'security':
                render_security_menu()
                char = show_select_option(char)

                try:
                    menu = security_menu_handler(char, menu)

                except click.Abort:
                    print('click.Abort')
                    menu = 'main'
                    continue
                except:
                    menu = 'main'
                    continue
            elif menu == 'logs':
                render_logs_menu(installed_app)
                char = show_select_option(char)

                try:
                    menu = handle_logs_menu_selection(installed_app,char)

                except click.Abort:
                    print('click.Abort')
                    menu = 'autoupdate'
                    continue
                except:
                    menu = 'main'
                    continue

            elif menu == 'server_performance':
                hanlde_server_performance_menu()
                menu = 'main'

            elif menu == 'akkadian_executor':

                render_akkadian_executor_menu()
                char = show_select_option(char)

                try:
                    menu = handle_akkadian_executor_selection(char, ctx, menu)
                except click.Abort:
                    print('click.Abort')
                    menu = 'autoupdate'
                    continue
                except:
                    menu = 'main'
                    continue

            elif menu == 'autoupdate':

                render_aam_management_menu()
                char = show_select_option(char)
                try:
                    menu, there_is_a_cli_update_in_folder_var = handle_auto_update_selection(char, ctx, menu)

                except click.Abort:
                    print('click.Abort')
                    menu = 'autoupdate'
                    continue

            elif menu == 'general':
                render_general_view_products_menu()
                char = show_select_option(char)

                menu = handle_general_menu_selection_manager(char, menu, installed_app)
                #TODO: migrate the code that uses the variables here!!!!

            elif menu == 'time':
                render_time_menu()
                char = show_select_option(char)
                menu = handle_time_menu(char, ctx, menu)

            elif menu == 'sync-servers':
                ntp_sync_server_menu()

                try:
                    char = show_select_option(char)
                    menu, values_to_update = handle_ntp_sync_servers_menu(char, menu, values_to_update)

                except KeyboardInterrupt:
                    menu = 'time'
                    continue

            elif menu == 'review_ntp_servers':
                click.clear()
                try:
                    menu = review_ntp_servers_handler(menu, values_to_update)

                except click.Abort:
                    menu = 'sync-servers'

            elif menu == 'update_applications':
                if installed_app == "pme_cm":
                    menu = 'update_pme'
                elif installed_app == "aco":
                    menu = 'update_aco'
                elif installed_app == "acm":
                    menu = 'update_cm'
                else:
                    menu = 'main'

            elif menu == 'aUU_menu':
                auu_menu()
                char = show_select_option(char)
                try:
                    menu = auu_menu_handler(char, menu)

                except click.Abort:
                    menu = 'main'

            elif menu == 'network':
                network_menu()
                char = show_select_option(char)

                dns1, dns2, gateway, ip, menu, netmask = network_menu_handler(char, ctx, dns1, dns2, gateway, interface,
                                                                              ip, menu, netmask)


            elif menu == 'replication_module_logs':
                click.clear()
                render_galera_management_menu()
                char = show_select_option(char)

                try:

                    if char == '1':
                        ctx.invoke(turn_off_replica_failover_logs)
                        menu = 'main'

                    elif char == '2':
                        ctx.invoke(turn_on_replica_failover_logs)

                    elif char == '3':
                        ctx.invoke(show_replica_failover_logs)
                        menu = 'main'

                    elif char == '4':
                        ctx.invoke(clean_replica_failover_logs)

                    elif char == "b":
                        menu = 'main'

                except click.Abort:
                    menu = 'main'

                    continue

                except KeyboardInterrupt:
                    menu = 'main'
                    continue

                except Exception:
                    menu = 'main'
                    continue

            elif menu == 'high_availability':
                click.clear()

                render_ha_main_view(installed_app)

                if is_full_ha_mode(installed_app):
                    click.secho('1: Remove High Availability Mode Cluster Config', fg='green')

                    if installed_app != "aco":
                        click.secho('2: Edit configs to receive notice about the status of HA', fg='green')
                        click.secho('3: Send notification test', fg='green')

                        click.secho('########################################################', fg='green')
                        click.secho('########################################################', fg='green')
                        click.secho('Please use these entries in case cluster has replication problems\n', fg='green')
                        click.secho('4: Show replica-failover service status', fg='green')
                        click.secho('5: Restart replica-failover service', fg='green')
                        #click.secho('6: Show replica-failover service logs', fg='green')
                        click.secho('6: Replication module logs service', fg='green')
                        click.secho('7: Edit replica-failover service logs configuration', fg='green')

                    if not maintenance_is_mode_on():
                        if installed_app != "aco":
                            click.secho('8: Turn on Maintenance Mode', fg='green')
                        else:
                            click.secho('2: Turn on Maintenance Mode', fg='green')

                    click.secho('b: Back to Main Menu', fg='red')

                    char = show_select_option(char)
                    try:
                        if char == '1':
                            ctx.invoke(remove_full_ha, installed_app=installed_app)
                            menu = 'main'

                        elif char == '2' and installed_app != "aco":
                            ctx.invoke(edit_email_configs)
                            menu = 'main'

                        elif char == '2' and installed_app == "aco":
                            ctx.invoke(maintenance_mode_on, installed_app=installed_app)

                        elif char == '3' and installed_app != "aco":
                            ctx.invoke(send_email_test)

                        elif char == '8' and installed_app != "aco":
                            ctx.invoke(maintenance_mode_prompt, installed_app=installed_app)

                        elif char == '4' and installed_app != "aco":
                            ctx.invoke(show_replica_failover_status)

                        elif char == '5' and installed_app != "aco":
                            ctx.invoke(restart_replica_failover_status)

                        elif char == '6' and installed_app != "aco":
                            #ctx.invoke(show_replica_failover_logs)
                            menu = 'replication_module_logs'

                        elif char == '7' and installed_app != "aco":
                            ctx.invoke(edit_replica_failover_logs_configs)

                        elif char == "b":
                            menu = 'main'
                    except click.Abort:
                        menu = 'main'
                        continue

                    except KeyboardInterrupt:
                        menu = 'main'
                        continue

                elif is_replication_mode_only(installed_app):
                    click.secho('1: Disable database replication', fg='green')

                    if installed_app != "aco":
                        click.secho('2: Edit configs to receive notice about the status of HA', fg='green')
                        click.secho('3: Send test notification', fg='green')
                        click.secho('########################################################', fg='green')
                        click.secho('########################################################', fg='green')
                        click.secho('Please use these entries in case cluster has replication problems', fg='green')
                        click.secho('4: Show replica-failover service status', fg='green')
                        click.secho('5: Restart replica-failover service', fg='green')
                        click.secho('6: Show replica-failover service logs', fg='green')
                        click.secho('7: Edit replica-failover service logs configuration', fg='green')

                    if not maintenance_is_mode_on():
                        if installed_app != "aco":
                            click.secho('8: Turn on Maintenance Mode', fg='green')
                        else:
                            click.secho('2: Turn on Maintenance Mode', fg='green')



                    click.secho('b: Back to Main Menu', fg='red')

                    char = show_select_option(char)
                    try:
                        if char == '1':
                            ctx.invoke(disable_replication_prompt, installed_app=installed_app)
                            menu = 'main'

                        elif char == '2' and installed_app != "aco":
                            ctx.invoke(edit_email_configs)
                            menu = 'main'

                        elif char == '2' and installed_app == "aco":
                            ctx.invoke(maintenance_mode_on, installed_app=installed_app)

                        elif char == '3' and installed_app != "aco":
                            ctx.invoke(send_email_test)

                        elif char == '8' and installed_app != "aco":
                            ctx.invoke(maintenance_mode_prompt, installed_app=installed_app)

                        elif char == '4' and installed_app != "aco":
                            ctx.invoke(show_replica_failover_status)

                        elif char == '5' and installed_app != "aco":
                            ctx.invoke(restart_replica_failover_status)

                        elif char == '6' and installed_app != "aco":
                            #ctx.invoke(show_replica_failover_logs)
                            menu = 'replication_module_logs'

                        elif char == '7' and installed_app != "aco":
                            ctx.invoke(edit_replica_failover_logs_configs)

                        elif char == "b":
                            menu = 'main'

                    except click.Abort:
                        menu = 'main'

                        continue

                    except KeyboardInterrupt:
                        menu = 'main'
                        continue

                elif maintenance_is_mode_on():
                    click.secho('1: Turn off maintenance mode', fg='green')
                    click.secho('b: Back to Main Menu', fg='red')
                    char = show_select_option(char)
                    try:
                        if char == "1":
                            click.secho('enabling replication, please wait...', fg='green')
                            ctx.invoke(maintenance_mode_off, installed_app=installed_app)
                        if char == "b":
                            menu = 'main'

                    except click.Abort:
                        menu = 'main'
                        continue

                    except KeyboardInterrupt:
                        menu = 'main'
                        continue
                else:

                    click.secho('High Availability/Load Balancer Configuration', fg='green')
                    click.secho('1: Enable High Availability', fg='green')
                    click.secho('2: Enable Database Replication', fg='green')

                    click.secho('Pre-requisites for High Availability:', fg='yellow')
                    click.secho('- All nodes have been assigned with a correct IP address', fg='yellow')
                    click.secho('- All nodes have a FQDN (name.domain.com)', fg='yellow')
                    click.secho('- An available IP address to be used as the virtual IP for the cluster', fg='yellow')
                    click.secho('- All nodes should be accessible via DNS\n', fg='yellow')

                    click.secho('b: Back to Main Menu', fg='red')

                    char = show_select_option(char)
                    try:
                        if char == "1":
                            r = ctx.invoke(start_full_ha, installed_app=installed_app)

                            if r:
                                menu = 'high_availability'
                            else:
                                click.pause('There was an error configuring HA, please review and try again, Press any key to continue...')
                                menu = 'main'

                        if char == "2":
                            r = ctx.invoke(start_replication, installed_app=installed_app, ha_nodes=None)

                            if r:
                                menu = 'high_availability'
                            else:
                                click.pause('There was an error configuring HA, please review and try again, Press any key to continue...')
                                menu = 'main'

                        if char == "b":
                            menu = 'main'

                    except click.Abort:
                        menu = 'main'
                        continue

                    except KeyboardInterrupt:
                        menu = 'main'
                        continue

            elif menu == 'update_pme':
                click.clear()

                if is_mastermaster_mastersalve_replication_enabled():
                    click.secho('Database Replication is enabled, please to ensure a correct\n'
                                'Akkadian Product installation, follow the steps in Master node:\n'
                                '1) go to Disable Database Replication inside High Availability menu.\n'
                                '3) go back here and ensure this explanation is gone\n', fg='yellow')

                    click.pause('Please press any key to go to Maintenance Mode.')

                    menu = 'ha_manage_sync'

                else:
                    pme_installation_menu()

                    try:
                        pme_option = show_select_option(char)

                        menu = pme_menu_handler(menu, pme_option)

                    except KeyboardInterrupt:
                        menu = 'update_applications'
                        continue

            elif menu == 'pme_from_url':
                menu = pme_from_url_handler(ctx, menu)

            elif menu == 'pme_from_file':
                menu = pme_from_file_handler(ctx, menu)

            elif menu == 'push_installation':
                if installed_app != 'aco':
                    menu = push_pme_cm_another_node(ctx, installed_app, menu)
                else:
                    click.pause(
                        'Akkadian Console Operator cannot be pushed automatically. Press any key to continue...')
                    menu = 'main'

            elif menu == 'update_aco':
                update_aco_menu()

                try:
                    aco_option = show_select_option(char)

                    menu = update_aco_menu_handler(aco_option, menu)

                except KeyboardInterrupt:
                    menu = 'update_applications'
                    continue

            elif menu == 'aco_from_url':
                try:
                    menu = install_aco_from_url(ctx, menu)

                except click.Abort:
                    menu = 'update_aco'

                except KeyboardInterrupt:
                    menu = 'update_aco'
                    continue

            elif menu == 'update_cm':
                click.clear()

                if is_mastermaster_mastersalve_replication_enabled():
                    click.secho('Database Replication is enabled, please to ensure a correct\n'
                                'Akkadian Product installation, follow the steps in Master node:\n'
                                '1) go to main menu -> Replication Support - Maintenance Mode\n'
                                '2) select option Disable Database Replication\n'
                                '3) go back here and ensure this explanation is gone\n', fg='yellow')

                    click.pause('Please press any key to go to Maintenance Mode.')

                    menu = 'high_availability'

                else:

                    update_acm_menu()

                    try:
                        acm_option = show_select_option(char)
                        try:
                            menu = update_acm_menu_handler(acm_option, char, ctx, menu)

                        except click.Abort:
                            menu = 'update_cm'

                    except KeyboardInterrupt:
                        menu = 'update_applications'
                        continue

            elif menu == 'pme_services' or menu == 'cm_services' or menu == 'asb_services':
                apm_acm_services_menu(menu)

                try:
                    char = show_select_option(char)

                    menu = apm_acm_services_menu_handler(char, installed_app, menu)

                except KeyboardInterrupt:
                    menu = 'general'
                    continue

            elif menu == 'aco_services':
                aco_services_menu()

                try:
                    char = show_select_option(char)

                    menu = aco_services_menu_handler(char, menu)

                except KeyboardInterrupt:
                    menu = 'general'
                    continue

            elif menu == 'apache':
                apache_menu()

                try:
                    char = show_select_option(char)

                    menu = apache_menu_handler(char, ctx, menu)

                except KeyboardInterrupt:
                    menu = 'pme_services'
                    continue

            elif menu == 'openldap':
                openldap_menu()
                try:
                    char = show_select_option(char)

                    menu = openldap_menu_handler(char, menu)

                except KeyboardInterrupt:
                    menu = 'pme_services'
                    continue

            elif menu == 'supervisor':
                supervisor_menu()

                try:
                    char = show_select_option(char)

                    menu = supervisor_menu_handler(char, ctx, menu)

                except click.Abort:
                    menu = 'main'
                    continue

                except Exception as e:
                    menu = 'main'
                    continue

            elif menu == 'pme_mysql':
                mysql_menu()

                try:
                    char = show_select_option(char)

                    menu = mysql_menu_handler(char, ctx, menu)

                except KeyboardInterrupt:
                    menu = 'pme_services'
                    continue

            elif menu == 'kestrel':
                aco_services_detailed_menu()

                try:
                    char = show_select_option(char)

                    menu = aco_detailed_services_menu_handler(char, ctx, menu)

                except KeyboardInterrupt:
                    menu = 'aco_services'
                    continue

            elif menu == 'mongo':
                mongo_menu()

                try:
                    char = show_select_option(char)

                    menu = mongo_menu_handler(char, ctx, menu)

                except KeyboardInterrupt:
                    menu = 'aco_services'
                    continue

            elif menu == 'aco_mysql':
                aco_mysql_menu()

                try:
                    char = show_select_option(char)

                    menu = aco_mysql_menu_handler(char, ctx, menu)

                except KeyboardInterrupt:
                    menu = 'aco_services'
                    continue
            
            elif menu == 'asm_menu':
                asm_menu()

                try:
                    char = show_select_option(char)

                    menu = asm_menu_handler(char, ctx, menu)

                except click.Abort:
                    menu = 'main'
                    continue

                except:
                    menu = 'main'
                    continue

            elif menu == 'cdr_menu':
                cdr_menu()

                try:
                    char = show_select_option(char)

                    menu = cdr_menu_handler(char, ctx, menu)

                except click.Abort:
                    menu = 'main'
                    continue

                except:
                    menu = 'main'
                    continue

            elif menu == 'nginx':
                nginx_menu()

                try:
                    char = show_select_option(char)

                    menu = nginx_menu_handler(char, ctx, menu)

                except KeyboardInterrupt:
                    menu = 'aco_services'
                    continue

            elif menu == 'tomcat':
                tomcat_menu()

                try:
                    char = show_select_option(char)

                    menu = tomcat_menu_handler(char, ctx, menu)

                except KeyboardInterrupt:
                    menu = 'aco_services'
                    continue

            elif menu == 'reboot':
                if click.confirm('Do you want to restart?'):
                    ctx.invoke(reboot)
                else:
                    menu = 'main'

            elif menu == 'shutdown':
                if click.confirm('Do you want to shutdown?'):
                    ctx.invoke(shutdown)
                else:
                    menu = 'main'

            elif menu == 'quit':
                ctx.invoke(kickoff_this_user)
        except click.Abort:
            menu = 'main'
            continue
        except EOFError:
            menu = 'main'
            continue
        except KeyboardInterrupt:
            menu = 'main'
            continue
