import subprocess
import time
from subprocess import Popen, PIPE

import click
import configparser
mapper = configparser.RawConfigParser()
mapper.read('mapper.ini')

def kestrel_stop():
    """
    Stop Kestrel Service
    """

    click.echo('Stopping...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'kestrelStop')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Kestrel Could not be Stopped', fg="red")
    else:
        click.secho('[OK] Kestrel Stopped Successfully', fg="yellow")

    time.sleep(3)


def kestrel_start():
    """
    Start Kestrel Service
    """

    click.echo('Starting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'kestrelStart')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Kestrel Could not be Started', fg="red")
    else:
        click.secho('[OK] Kestrel Started Successfully', fg="yellow")

    time.sleep(3)


def kestrel_restart():
    """
    Restart Kestrel Service
    """

    click.echo('Restarting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'kestrelRestart')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Kestrel Could not be Restarted', fg="red")
    else:
        click.secho('[OK] Kestrel Restarted Successfully', fg="yellow")

    time.sleep(3)


def kestrel_configs():
    """
    Changing Kestrel Service Configs
    """

    click.echo('Starting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'kestrelConfigs')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] ACO Server Configs Applied Error', fg="red")
    else:
        click.secho('[OK] ACO Server Configs Applied Successfully', fg="yellow")
        click.secho('Please Reboot the Server Completely', fg="yellow")

    time.sleep(3)


def mongo_stop():
    """
    Stop MongoDB Service
    """

    click.echo('Stopping...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'mongoStop')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] MongoDB Could not be Stopped', fg="red")
    else:
        click.secho('[OK] MongoDB Stopped Successfully', fg="yellow")

    time.sleep(3)


def mongo_start():
    """
    Start MongoDB Service
    """

    click.echo('Starting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'mongoStart')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] MongoDB Could not be Started', fg="red")
    else:
        click.secho('[OK] MongoDB Started Successfully', fg="yellow")

    time.sleep(3)


def mongo_restart():
    """
    Restart MongoDB Service
    """

    click.echo('Restarting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'mongoRestart')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] MongoDB Could not be Restarted', fg="red")
    else:
        click.secho('[OK] MongoDB Restarted Successfully', fg="yellow")

    time.sleep(3)


def aco_mysql_stop():
    """
    Stop ACO MySQL Service
    """

    click.echo('Stopping...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'acoMysqlStop')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] MySQL Could not be Stopped', fg="red")
    else:
        click.secho('[OK] MySQL Stopped Successfully', fg="yellow")

    time.sleep(3)


def aco_mysql_start():
    """
    Start ACO MySQL Service
    """

    click.echo('Starting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'acoMysqlStart')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] MySQL Could not be Started', fg="red")
    else:
        click.secho('[OK] MySQL Started Successfully', fg="yellow")

    time.sleep(3)


def aco_mysql_restart():
    """
    Restart ACO MySQL Service
    """

    click.echo('Restarting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'acoMysqlRestart')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] MySQL Could not be Restarted', fg="red")
    else:
        click.secho('[OK] MySQL Restarted Successfully', fg="yellow")

    time.sleep(3)


def nginx_stop():
    """
    Stop Nginx Service
    """

    click.echo('Stopping...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'nginxStop')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Nginx Could not be Stopped', fg="red")
    else:
        click.secho('[OK] Nginx Stopped Successfully', fg="yellow")

    time.sleep(3)


def nginx_start():
    """
    Start Nginx Service
    """

    click.echo('Starting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'nginxStart')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Nginx Could not be Started', fg="red")
    else:
        click.secho('[OK] Nginx Started Successfully', fg="yellow")

    time.sleep(3)


def nginx_restart():
    """
    Restart Nginx Service
    """

    click.echo('Restarting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'nginxRestart')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Nginx Could not be Restarted', fg="red")
    else:
        click.secho('[OK] Nginx Restarted Successfully', fg="yellow")

    time.sleep(3)


def nginx_config():
    """
    Changing Nginx Configs
    """

    click.echo('Starting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'nginxOverrideConfigs')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Nginx Could not be updated', fg="red")
    else:
        click.secho('[OK] Nginx was updated Successfully, Nginx.', fg="yellow")

    time.sleep(3)


def tomcat_stop():
    """
    Stop Tomcat Service
    """

    click.echo('Stopping...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'tomcatStop')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Tomcat Could not be Stopped', fg="red")
    else:
        click.secho('[OK] Tomcat Stopped Successfully', fg="yellow")

    time.sleep(3)


def tomcat_start():
    """
    Start Nginx Service
    """

    click.echo('Starting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'tomcatStart')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Tomcat Could not be Started', fg="red")
    else:
        click.secho('[OK] Tomcat Started Successfully', fg="yellow")

    time.sleep(3)


def tomcat_restart():
    """
    Restart Tomcat Service
    """

    click.echo('Restarting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'tomcatRestart')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Tomcat Could not be Restarted', fg="red")
    else:
        click.secho('[OK] Tomcat Restarted Successfully', fg="yellow")

    time.sleep(3)


def aco_update(zip_installer, jtapi_version):
    """
    Update ACO
    """

    p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'acoUpdateScript'), zip_installer, jtapi_version],
                         stdout=PIPE, stderr=PIPE)

    out, err = p.communicate()
    time.sleep(10)

    for line in out.splitlines():
        line = line.decode("utf-8")
        if 'ERROR' in line:
            click.pause('ACO was not updated. Press any key to continue...')
            return

    click.pause('ACO was updated correctly. Press any key to continue...')
    return


def server_certificates_update(zipinstaller, md5code):
    """
    Update ACO SERVER CERTIFICATES
    """

    p = subprocess.Popen(["sh", mapper.get('ApplicationScripts', 'serverCertUpdateScript'), zipinstaller, md5code],
                         stdout=PIPE, stderr=PIPE)

    out, err = p.communicate()
    for line in out.splitlines():
        line = line.decode("utf-8")
        if 'ERROR' in line:
            click.pause('ACO SERVER CERTIFICATES was not updated. Press any key to continue...')
            return

    click.pause('ACO SERVER CERTIFICATES was updated correctly. Press any key to continue...')
    return


def web_certificates_update(zipinstaller, md5code):
    """
    Update ACO WEB CERTIFICATES
    """

    p = subprocess.Popen(["sh", mapper.get('ApplicationScripts', 'webCertUpdateScript'), zipinstaller, md5code],
                         stdout=PIPE, stderr=PIPE)

    out, err = p.communicate()
    for line in out.splitlines():
        line = line.decode("utf-8")
        if 'ERROR' in line:
            click.pause('ACO WEB CERTIFICATES was not updated. Press any key to continue...')
            return

    click.pause('ACO WEB CERTIFICATES was updated correctly. Press any key to continue...')
    return


def edit_logback():
    """Edit logback file"""
    click.edit(filename=mapper.get('GeneralConfigs', 'logback'))


def edit_acolog():
    """Edit acolog file"""
    click.edit(filename=mapper.get('GeneralConfigs', 'acolog'))


def tail_f_acoserver():
    click.echo('tail into file...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'acologtail')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    time.sleep(3)


def tail_f_acoweb():
    click.echo('tail into file...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'weblogtail')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    time.sleep(3)


def remove_events_duplicated():
    click.echo('removing duplicated...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'removeDuplicated')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    time.sleep(3)


def see_console_events():
    click.echo('getting console events...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'getConsoleEvents')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    time.sleep(3)


def see_console_events_web():
    click.echo('getting web console events...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'getConsoleEventsWeb')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    time.sleep(3)


def reset_aco_admin_pass():
    click.echo('Reseting Admin password...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'resetACOAdminPass')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    time.sleep(3)


def get_jtapi(cucm_url):
    try:
        p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'getJtapiLibrary'), cucm_url], stdout=PIPE,
                             stderr=PIPE)

        for line in p.stdout:
            line = line.decode("utf-8")
            print(line)

    except Exception as e:

        print(e)
        return False


def generate_aco_certificate():
    if click.confirm('This action can modify the behavior of your server, Are you sure you want to continue?'):
        p = Popen(["sh", mapper.get('GeneralScripts', 'generateAcoCertificates')], stdout=PIPE, stderr=PIPE)
        for line in p.stdout:
            line = line.decode("utf-8")
            print(line)
        p.wait()

        click.pause('Certificate Generated Correctly, please press any key to continue...')