
import logging.config
import os
from os import path

from watchdog.events import FileSystemEventHandler
from watchdog.observers import Observer

from cdr_db_handler import CDRDBHandler
from cdr_file_handler import CDRFileHandler

#logging.basicConfig(filename='myapp.log', level=logging.INFO, format='%(asctime)s %(levelname)s AkkadianCDRCollector: %(message)s', datefmt='%Y-%m-%dT%H:%M:%S%z')
log_file_path = path.join(path.dirname(path.abspath(__file__)), 'logging.ini')
logging.config.fileConfig(log_file_path, disable_existing_loggers=False)
logger = logging.getLogger(__name__)

def init():
    """Loads up the config and returns the values. Also checks for and creates tracking table if it doesnt exist.

    Raises:
        e: General exception raised when error occurs

    Returns:
        config (dictionary): The config paramters in a dictionary 
    """
    try: 
        logger.info('Starting Akkadian CDR Data Collection Service')
        config = CDRDBHandler.loadConfig() # test config loading.
        tracking_exists = CDRDBHandler.check_table_exists('akk_cdr_tracking')
        if tracking_exists == False:
            CDRDBHandler.create_tracking_table()
        else:
            # these are basically database changes for backwards compatibility
            CDRDBHandler.run_tracking_table_upgrades()
            CDRDBHandler.run_db_index_speedup()
            
        
        return config
    except Exception as e:
        logger.error('Init failed.')
        exit(1)

    

if __name__ == "__main__":
    try:
        config = init()
        path = config['cdr_location']
        event_handler = CDRFileHandler()
        observer = Observer()
        observer.schedule(event_handler, path, recursive=False) # watch folder for file creations
        observer.start()
        logger.info('Initialiased Akkadian CDR Data Collection Service. Ready.')

        while observer.isAlive():
            observer.join(5)
    except KeyboardInterrupt:
        logger.info('Data Collector stopped. Exiting')
        observer.stop()
        exit(0)
    except Exception as e:
        logger.critical(f"{type(e).__name__} at line {e.__traceback__.tb_lineno} of {__file__}: {e}")
        logger.critical('A problem occured and the data collector stopped. Exiting',flush=True)
        #print(f"{type(e).__name__} at line {e.__traceback__.tb_lineno} of {__file__}: {e}",flush=True)
        observer.stop()
        exit(1)
    observer.join()
